/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLConfig;
import org.lwjgl.opengles.EGLContext;
import org.lwjgl.opengles.EGLSurface;

public final class EGLDisplay
extends PointerWrapperAbstract {
    private int majorVersion;
    private int minorVersion;
    private Set<String> extensions;
    private boolean initialized;

    EGLDisplay(long pointer) throws LWJGLException {
        super(pointer);
        this.initialize();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isExtensionSupported(String eglExtension) {
        this.checkInitialized();
        if (this.extensions == null) {
            this.extensions = new HashSet<String>(16);
            StringTokenizer tokenizer = new StringTokenizer(EGL.eglQueryString(this, 12373));
            while (tokenizer.hasMoreTokens()) {
                this.extensions.add(tokenizer.nextToken());
            }
        }
        return this.extensions.contains(eglExtension);
    }

    boolean isInitialized() {
        return this.initialized;
    }

    private void initialize() throws LWJGLException {
        IntBuffer version = APIUtil.getBufferInt();
        EGL.eglInitialize(this, version);
        this.majorVersion = version.get(0);
        this.minorVersion = version.get(1);
        this.initialized = true;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("The EGL display needs to be initialized first.");
        }
    }

    public void terminate() throws LWJGLException {
        EGL.eglTerminate(this);
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.initialized = false;
    }

    public String query(int name) {
        this.checkInitialized();
        return EGL.eglQueryString(this, name);
    }

    int getConfigsNum() throws LWJGLException {
        this.checkInitialized();
        return EGL.eglGetConfigsNum(this);
    }

    EGLConfig[] getConfigs(EGLConfig[] configs, IntBuffer num_config) throws LWJGLException {
        this.checkInitialized();
        return EGL.eglGetConfigs(this, configs, num_config);
    }

    int getConfigNum(IntBuffer attrib_list) throws LWJGLException {
        this.checkInitialized();
        return EGL.eglChooseConfigNum(this, attrib_list);
    }

    public EGLConfig[] chooseConfig(IntBuffer attrib_list, EGLConfig[] configs, IntBuffer num_config) throws LWJGLException {
        this.checkInitialized();
        return EGL.eglChooseConfig(this, attrib_list, configs, num_config);
    }

    public EGLSurface createWindowSurface(EGLConfig config, long window, IntBuffer attrib_list) throws LWJGLException {
        this.checkInitialized();
        if (config.getDisplay() != this) {
            throw new IllegalArgumentException("Invalid EGL config specified.");
        }
        return EGL.eglCreateWindowSurface(this, config, window, attrib_list);
    }

    EGLSurface createPbufferSurface(EGLConfig config, IntBuffer attrib_list) throws LWJGLException {
        this.checkInitialized();
        if (config.getDisplay() != this) {
            throw new IllegalArgumentException("Invalid EGL config specified.");
        }
        return EGL.eglCreatePbufferSurface(this, config, attrib_list);
    }

    public EGLContext createContext(EGLConfig config, EGLContext shareContext, IntBuffer attrib_list) throws LWJGLException {
        this.checkInitialized();
        if (config.getDisplay() != this) {
            throw new IllegalStateException("Invalid EGL config specified.");
        }
        if (shareContext != null && shareContext.getDisplay() != this) {
            throw new IllegalStateException("Invalid shared EGL context specified.");
        }
        return EGL.eglCreateContext(this, config, shareContext, attrib_list);
    }

    public void setSwapInterval(int interval) throws LWJGLException {
        EGL.eglSwapInterval(this, interval);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EGLDisplay)) {
            return false;
        }
        return this.getPointer() == ((EGLDisplay)obj).getPointer();
    }
}

