/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class EXTSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT_EXT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT_EXT = 2;
    public static final int GL_ALL_SHADER_BITS_EXT = -1;
    public static final int GL_PROGRAM_SEPARABLE_EXT = 33368;
    public static final int GL_ACTIVE_PROGRAM_EXT = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING_EXT = 33370;

    private EXTSeparateShaderObjects() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glUseProgramStagesEXT(int pipeline, int stages, int program) {
        EXTSeparateShaderObjects.nglUseProgramStagesEXT(pipeline, stages, program);
    }

    static native void nglUseProgramStagesEXT(int var0, int var1, int var2);

    public static void glActiveShaderProgramEXT(int pipeline, int program) {
        EXTSeparateShaderObjects.nglActiveShaderProgramEXT(pipeline, program);
    }

    static native void nglActiveShaderProgramEXT(int var0, int var1);

    public static int glCreateShaderProgramEXT(int type, ByteBuffer string) {
        BufferChecks.checkDirect(string);
        BufferChecks.checkNullTerminated(string);
        int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, 1, MemoryUtil.getAddress(string));
        return __result;
    }

    static native int nglCreateShaderProgramvEXT(int var0, int var1, long var2);

    public static int glCreateShaderProgramEXT(int type, int count, ByteBuffer strings) {
        BufferChecks.checkDirect(strings);
        BufferChecks.checkNullTerminated(strings, count);
        int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT2(type, count, MemoryUtil.getAddress(strings));
        return __result;
    }

    static native int nglCreateShaderProgramvEXT2(int var0, int var1, long var2);

    public static int glCreateShaderProgramEXT(int type, ByteBuffer[] strings) {
        BufferChecks.checkArray(strings, 1);
        int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT3(type, strings.length, strings);
        return __result;
    }

    static native int nglCreateShaderProgramvEXT3(int var0, int var1, ByteBuffer[] var2);

    public static int glCreateShaderProgramEXT(int type, CharSequence string) {
        int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, 1, APIUtil.getBufferNT(string));
        return __result;
    }

    public static int glCreateShaderProgramEXT(int type, CharSequence[] strings) {
        BufferChecks.checkArray(strings);
        int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT2(type, strings.length, APIUtil.getBufferNT(strings));
        return __result;
    }

    public static void glBindProgramPipelineEXT(int pipeline) {
        EXTSeparateShaderObjects.nglBindProgramPipelineEXT(pipeline);
    }

    static native void nglBindProgramPipelineEXT(int var0);

    public static void glDeleteProgramPipelinesEXT(IntBuffer pipelines) {
        BufferChecks.checkDirect(pipelines);
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.getAddress(pipelines));
    }

    static native void nglDeleteProgramPipelinesEXT(int var0, long var1);

    public static void glDeleteProgramPipelinesEXT(int pipeline) {
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(1, APIUtil.getInt(pipeline));
    }

    public static void glGenProgramPipelinesEXT(IntBuffer pipelines) {
        BufferChecks.checkDirect(pipelines);
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.getAddress(pipelines));
    }

    static native void nglGenProgramPipelinesEXT(int var0, long var1);

    public static int glGenProgramPipelinesEXT() {
        IntBuffer pipelines = APIUtil.getBufferInt();
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(1, MemoryUtil.getAddress(pipelines));
        return pipelines.get(0);
    }

    public static boolean glIsProgramPipelineEXT(int pipeline) {
        boolean __result = EXTSeparateShaderObjects.nglIsProgramPipelineEXT(pipeline);
        return __result;
    }

    static native boolean nglIsProgramPipelineEXT(int var0);

    public static void glProgramParameteriEXT(int program, int pname, int value) {
        EXTSeparateShaderObjects.nglProgramParameteriEXT(program, pname, value);
    }

    static native void nglProgramParameteriEXT(int var0, int var1, int var2);

    public static void glGetProgramPipelineEXT(int pipeline, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetProgramPipelineivEXT(int var0, int var1, long var2);

    public static int glGetProgramPipelineiEXT(int pipeline, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glProgramUniform1iEXT(int program, int location, int v0) {
        EXTSeparateShaderObjects.nglProgramUniform1iEXT(program, location, v0);
    }

    static native void nglProgramUniform1iEXT(int var0, int var1, int var2);

    public static void glProgramUniform2iEXT(int program, int location, int v0, int v1) {
        EXTSeparateShaderObjects.nglProgramUniform2iEXT(program, location, v0, v1);
    }

    static native void nglProgramUniform2iEXT(int var0, int var1, int var2, int var3);

    public static void glProgramUniform3iEXT(int program, int location, int v0, int v1, int v2) {
        EXTSeparateShaderObjects.nglProgramUniform3iEXT(program, location, v0, v1, v2);
    }

    static native void nglProgramUniform3iEXT(int var0, int var1, int var2, int var3, int var4);

    public static void glProgramUniform4iEXT(int program, int location, int v0, int v1, int v2, int v3) {
        EXTSeparateShaderObjects.nglProgramUniform4iEXT(program, location, v0, v1, v2, v3);
    }

    static native void nglProgramUniform4iEXT(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glProgramUniform1fEXT(int program, int location, float v0) {
        EXTSeparateShaderObjects.nglProgramUniform1fEXT(program, location, v0);
    }

    static native void nglProgramUniform1fEXT(int var0, int var1, float var2);

    public static void glProgramUniform2fEXT(int program, int location, float v0, float v1) {
        EXTSeparateShaderObjects.nglProgramUniform2fEXT(program, location, v0, v1);
    }

    static native void nglProgramUniform2fEXT(int var0, int var1, float var2, float var3);

    public static void glProgramUniform3fEXT(int program, int location, float v0, float v1, float v2) {
        EXTSeparateShaderObjects.nglProgramUniform3fEXT(program, location, v0, v1, v2);
    }

    static native void nglProgramUniform3fEXT(int var0, int var1, float var2, float var3, float var4);

    public static void glProgramUniform4fEXT(int program, int location, float v0, float v1, float v2, float v3) {
        EXTSeparateShaderObjects.nglProgramUniform4fEXT(program, location, v0, v1, v2, v3);
    }

    static native void nglProgramUniform4fEXT(int var0, int var1, float var2, float var3, float var4, float var5);

    public static void glProgramUniform1EXT(int program, int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform1ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2EXT(int program, int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform2ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3EXT(int program, int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform3ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4EXT(int program, int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform4ivEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1EXT(int program, int location, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform1fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform2EXT(int program, int location, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform2fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform3EXT(int program, int location, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform3fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniform4EXT(int program, int location, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniform4fvEXT(int var0, int var1, int var2, long var3);

    public static void glProgramUniformMatrix2EXT(int program, int location, boolean transpose, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniformMatrix2fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix3EXT(int program, int location, boolean transpose, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniformMatrix3fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glProgramUniformMatrix4EXT(int program, int location, boolean transpose, FloatBuffer value) {
        BufferChecks.checkDirect(value);
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.getAddress(value));
    }

    static native void nglProgramUniformMatrix4fvEXT(int var0, int var1, int var2, boolean var3, long var4);

    public static void glValidateProgramPipelineEXT(int pipeline) {
        EXTSeparateShaderObjects.nglValidateProgramPipelineEXT(pipeline);
    }

    static native void nglValidateProgramPipelineEXT(int var0);

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog));
    }

    static native void nglGetProgramPipelineInfoLogEXT(int var0, int var1, long var2, long var4);

    public static String glGetProgramPipelineInfoLogEXT(int pipeline, int bufSize) {
        IntBuffer infoLog_length = APIUtil.getLengths();
        ByteBuffer infoLog = APIUtil.getBufferByte(bufSize);
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, MemoryUtil.getAddress0(infoLog_length), MemoryUtil.getAddress(infoLog));
        infoLog.limit(infoLog_length.get(0));
        return APIUtil.getString(infoLog);
    }
}

