/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.GLChecks;
import org.lwjgl.opengles.StateTracker;

public final class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX = 6401;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;

    private GLES20() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glActiveTexture(int texture) {
        GLES20.nglActiveTexture(texture);
    }

    static native void nglActiveTexture(int var0);

    public static void glAttachShader(int program, int shader) {
        GLES20.nglAttachShader(program, shader);
    }

    static native void nglAttachShader(int var0, int var1);

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        GLES20.nglBindAttribLocation(program, index, MemoryUtil.getAddress(name));
    }

    static native void nglBindAttribLocation(int var0, int var1, long var2);

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        GLES20.nglBindAttribLocation(program, index, APIUtil.getBufferNT(name));
    }

    public static void glBindBuffer(int target, int buffer) {
        StateTracker.bindBuffer(target, buffer);
        GLES20.nglBindBuffer(target, buffer);
    }

    static native void nglBindBuffer(int var0, int var1);

    public static void glBindFramebuffer(int target, int framebuffer) {
        GLES20.nglBindFramebuffer(target, framebuffer);
    }

    static native void nglBindFramebuffer(int var0, int var1);

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        GLES20.nglBindRenderbuffer(target, renderbuffer);
    }

    static native void nglBindRenderbuffer(int var0, int var1);

    public static void glBindTexture(int target, int texture) {
        GLES20.nglBindTexture(target, texture);
    }

    static native void nglBindTexture(int var0, int var1);

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        GLES20.nglBlendColor(red, green, blue, alpha);
    }

    static native void nglBlendColor(float var0, float var1, float var2, float var3);

    public static void glBlendEquation(int mode) {
        GLES20.nglBlendEquation(mode);
    }

    static native void nglBlendEquation(int var0);

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GLES20.nglBlendEquationSeparate(modeRGB, modeAlpha);
    }

    static native void nglBlendEquationSeparate(int var0, int var1);

    public static void glBlendFunc(int sfactor, int dfactor) {
        GLES20.nglBlendFunc(sfactor, dfactor);
    }

    static native void nglBlendFunc(int var0, int var1);

    public static void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GLES20.nglBlendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    static native void nglBlendFuncSeparate(int var0, int var1, int var2, int var3);

    public static void glBufferData(int target, long data_size, int usage) {
        GLES20.nglBufferData(target, data_size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferData(target, data.remaining(), MemoryUtil.getAddress(data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferData(target, data.remaining() << 1, MemoryUtil.getAddress(data), usage);
    }

    static native void nglBufferData(int var0, long var1, long var3, int var5);

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.getAddress(data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.getAddress(data));
    }

    static native void nglBufferSubData(int var0, long var1, long var3, long var5);

    public static int glCheckFramebufferStatus(int target) {
        int __result = GLES20.nglCheckFramebufferStatus(target);
        return __result;
    }

    static native int nglCheckFramebufferStatus(int var0);

    public static void glClear(int mask) {
        GLES20.nglClear(mask);
    }

    static native void nglClear(int var0);

    public static void glClearColor(float red, float green, float blue, float alpha) {
        GLES20.nglClearColor(red, green, blue, alpha);
    }

    static native void nglClearColor(float var0, float var1, float var2, float var3);

    public static void glClearDepthf(float depth) {
        GLES20.nglClearDepthf(depth);
    }

    static native void nglClearDepthf(float var0);

    public static void glClearStencil(int s) {
        GLES20.nglClearStencil(s);
    }

    static native void nglClearStencil(int var0);

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GLES20.nglColorMask(red, green, blue, alpha);
    }

    static native void nglColorMask(boolean var0, boolean var1, boolean var2, boolean var3);

    public static void glCompileShader(int shader) {
        GLES20.nglCompileShader(shader);
    }

    static native void nglCompileShader(int var0);

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, data.remaining(), MemoryUtil.getAddress(data));
    }

    static native void nglCompressedTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        BufferChecks.checkDirect(data);
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.getAddress(data));
    }

    static native void nglCompressedTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GLES20.nglCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    static native void nglCopyTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GLES20.nglCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    static native void nglCopyTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static int glCreateProgram() {
        int __result = GLES20.nglCreateProgram();
        return __result;
    }

    static native int nglCreateProgram();

    public static int glCreateShader(int type) {
        int __result = GLES20.nglCreateShader(type);
        return __result;
    }

    static native int nglCreateShader(int var0);

    public static void glCullFace(int mode) {
        GLES20.nglCullFace(mode);
    }

    static native void nglCullFace(int var0);

    public static void glDeleteBuffers(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        GLES20.nglDeleteBuffers(buffers.remaining(), MemoryUtil.getAddress(buffers));
    }

    static native void nglDeleteBuffers(int var0, long var1);

    public static void glDeleteBuffers(int buffer) {
        GLES20.nglDeleteBuffers(1, APIUtil.getInt(buffer));
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        BufferChecks.checkDirect(framebuffers);
        GLES20.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.getAddress(framebuffers));
    }

    static native void nglDeleteFramebuffers(int var0, long var1);

    public static void glDeleteFramebuffers(int framebuffer) {
        GLES20.nglDeleteFramebuffers(1, APIUtil.getInt(framebuffer));
    }

    public static void glDeleteProgram(int program) {
        GLES20.nglDeleteProgram(program);
    }

    static native void nglDeleteProgram(int var0);

    public static void glDeleteRenderbuffers(IntBuffer renderbuffers) {
        BufferChecks.checkDirect(renderbuffers);
        GLES20.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.getAddress(renderbuffers));
    }

    static native void nglDeleteRenderbuffers(int var0, long var1);

    public static void glDeleteRenderbuffers(int renderbuffer) {
        GLES20.nglDeleteRenderbuffers(1, APIUtil.getInt(renderbuffer));
    }

    public static void glDeleteShader(int shader) {
        GLES20.nglDeleteShader(shader);
    }

    static native void nglDeleteShader(int var0);

    public static void glDeleteTextures(IntBuffer textures) {
        BufferChecks.checkDirect(textures);
        GLES20.nglDeleteTextures(textures.remaining(), MemoryUtil.getAddress(textures));
    }

    static native void nglDeleteTextures(int var0, long var1);

    public static void glDeleteTextures(int texture) {
        GLES20.nglDeleteTextures(1, APIUtil.getInt(texture));
    }

    public static void glDepthFunc(int func) {
        GLES20.nglDepthFunc(func);
    }

    static native void nglDepthFunc(int var0);

    public static void glDepthMask(boolean flag) {
        GLES20.nglDepthMask(flag);
    }

    static native void nglDepthMask(boolean var0);

    public static void glDepthRangef(float zNear, float zFar) {
        GLES20.nglDepthRangef(zNear, zFar);
    }

    static native void nglDepthRangef(float var0, float var1);

    public static void glDetachShader(int program, int shader) {
        GLES20.nglDetachShader(program, shader);
    }

    static native void nglDetachShader(int var0, int var1);

    public static void glDisable(int cap) {
        GLES20.nglDisable(cap);
    }

    static native void nglDisable(int var0);

    public static void glDisableVertexAttribArray(int index) {
        GLES20.nglDisableVertexAttribArray(index);
    }

    static native void nglDisableVertexAttribArray(int var0);

    public static void glDrawArrays(int mode, int first, int count) {
        GLES20.nglDrawArrays(mode, first, count);
    }

    static native void nglDrawArrays(int var0, int var1, int var2);

    public static void glDrawElements(int mode, ByteBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES20.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.getAddress(indices));
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES20.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.getAddress(indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES20.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.getAddress(indices));
    }

    static native void nglDrawElements(int var0, int var1, int var2, long var3);

    public static void glDrawElements(int mode, int indices_count, int type, long indices_buffer_offset) {
        GLChecks.ensureElementVBOenabled();
        GLES20.nglDrawElementsBO(mode, indices_count, type, indices_buffer_offset);
    }

    static native void nglDrawElementsBO(int var0, int var1, int var2, long var3);

    public static void glEnable(int cap) {
        GLES20.nglEnable(cap);
    }

    static native void nglEnable(int var0);

    public static void glEnableVertexAttribArray(int index) {
        GLES20.nglEnableVertexAttribArray(index);
    }

    static native void nglEnableVertexAttribArray(int var0);

    public static void glFinish() {
        GLES20.nglFinish();
    }

    static native void nglFinish();

    public static void glFlush() {
        GLES20.nglFlush();
    }

    static native void nglFlush();

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        GLES20.nglFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    }

    static native void nglFramebufferRenderbuffer(int var0, int var1, int var2, int var3);

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        GLES20.nglFramebufferTexture2D(target, attachment, textarget, texture, level);
    }

    static native void nglFramebufferTexture2D(int var0, int var1, int var2, int var3, int var4);

    public static void glFrontFace(int mode) {
        GLES20.nglFrontFace(mode);
    }

    static native void nglFrontFace(int var0);

    public static void glGenBuffers(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        GLES20.nglGenBuffers(buffers.remaining(), MemoryUtil.getAddress(buffers));
    }

    static native void nglGenBuffers(int var0, long var1);

    public static int glGenBuffers() {
        IntBuffer buffers = APIUtil.getBufferInt();
        GLES20.nglGenBuffers(1, MemoryUtil.getAddress(buffers));
        return buffers.get(0);
    }

    public static void glGenerateMipmap(int target) {
        GLES20.nglGenerateMipmap(target);
    }

    static native void nglGenerateMipmap(int var0);

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        BufferChecks.checkDirect(framebuffers);
        GLES20.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.getAddress(framebuffers));
    }

    static native void nglGenFramebuffers(int var0, long var1);

    public static int glGenFramebuffers() {
        IntBuffer framebuffers = APIUtil.getBufferInt();
        GLES20.nglGenFramebuffers(1, MemoryUtil.getAddress(framebuffers));
        return framebuffers.get(0);
    }

    public static void glGenRenderbuffers(IntBuffer renderbuffers) {
        BufferChecks.checkDirect(renderbuffers);
        GLES20.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.getAddress(renderbuffers));
    }

    static native void nglGenRenderbuffers(int var0, long var1);

    public static int glGenRenderbuffers() {
        IntBuffer renderbuffers = APIUtil.getBufferInt();
        GLES20.nglGenRenderbuffers(1, MemoryUtil.getAddress(renderbuffers));
        return renderbuffers.get(0);
    }

    public static void glGenTextures(IntBuffer textures) {
        BufferChecks.checkDirect(textures);
        GLES20.nglGenTextures(textures.remaining(), MemoryUtil.getAddress(textures));
    }

    static native void nglGenTextures(int var0, long var1);

    public static int glGenTextures() {
        IntBuffer textures = APIUtil.getBufferInt();
        GLES20.nglGenTextures(1, MemoryUtil.getAddress(textures));
        return textures.get(0);
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        GLES20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name));
    }

    static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static String glGetActiveAttrib(int program, int index, int bufsize, IntBuffer sizeType) {
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer name_length = APIUtil.getLengths();
        ByteBuffer name = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetActiveAttrib(program, index, bufsize, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(name));
        name.limit(name_length.get(0));
        return APIUtil.getString(name);
    }

    public static String glGetActiveAttrib(int program, int index, int bufsize) {
        IntBuffer name_length = APIUtil.getLengths();
        ByteBuffer name = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetActiveAttrib(program, index, bufsize, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress0(APIUtil.getBufferInt()), MemoryUtil.getAddress(APIUtil.getBufferInt(), 1), MemoryUtil.getAddress(name));
        name.limit(name_length.get(0));
        return APIUtil.getString(name);
    }

    public static int glGetActiveAttribSize(int program, int index) {
        IntBuffer size = APIUtil.getBufferInt();
        GLES20.nglGetActiveAttrib(program, index, 0, 0L, MemoryUtil.getAddress(size), MemoryUtil.getAddress(size, 1), APIUtil.getBufferByte0());
        return size.get(0);
    }

    public static int glGetActiveAttribType(int program, int index) {
        IntBuffer type = APIUtil.getBufferInt();
        GLES20.nglGetActiveAttrib(program, index, 0, 0L, MemoryUtil.getAddress(type, 1), MemoryUtil.getAddress(type), APIUtil.getBufferByte0());
        return type.get(0);
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        GLES20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name));
    }

    static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static String glGetActiveUniform(int program, int index, int bufsize, IntBuffer sizeType) {
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer name_length = APIUtil.getLengths();
        ByteBuffer name = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetActiveUniform(program, index, bufsize, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(name));
        name.limit(name_length.get(0));
        return APIUtil.getString(name);
    }

    public static String glGetActiveUniform(int program, int index, int bufsize) {
        IntBuffer name_length = APIUtil.getLengths();
        ByteBuffer name = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetActiveUniform(program, index, bufsize, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress0(APIUtil.getBufferInt()), MemoryUtil.getAddress(APIUtil.getBufferInt(), 1), MemoryUtil.getAddress(name));
        name.limit(name_length.get(0));
        return APIUtil.getString(name);
    }

    public static int glGetActiveUniformSize(int program, int index) {
        IntBuffer size = APIUtil.getBufferInt();
        GLES20.nglGetActiveUniform(program, index, 0, 0L, MemoryUtil.getAddress(size), MemoryUtil.getAddress(size, 1), APIUtil.getBufferByte0());
        return size.get(0);
    }

    public static int glGetActiveUniformType(int program, int index) {
        IntBuffer type = APIUtil.getBufferInt();
        GLES20.nglGetActiveUniform(program, index, 0, 0L, MemoryUtil.getAddress(type, 1), MemoryUtil.getAddress(type), APIUtil.getBufferByte0());
        return type.get(0);
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (count != null) {
            BufferChecks.checkBuffer(count, 1);
        }
        BufferChecks.checkDirect(shaders);
        GLES20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.getAddressSafe(count), MemoryUtil.getAddress(shaders));
    }

    static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4);

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int __result = GLES20.nglGetAttribLocation(program, MemoryUtil.getAddress(name));
        return __result;
    }

    static native int nglGetAttribLocation(int var0, long var1);

    public static int glGetAttribLocation(int program, CharSequence name) {
        int __result = GLES20.nglGetAttribLocation(program, APIUtil.getBufferNT(name));
        return __result;
    }

    public static void glGetBoolean(int pname, ByteBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetBooleanv(pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetBooleanv(int var0, long var1);

    public static boolean glGetBoolean(int pname) {
        ByteBuffer params = APIUtil.getBufferByte(1);
        GLES20.nglGetBooleanv(pname, MemoryUtil.getAddress(params));
        return params.get(0) == 1;
    }

    public static void glGetBufferParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetBufferParameteriv(int var0, int var1, long var2);

    @Deprecated
    public static int glGetBufferParameter(int target, int pname) {
        return GLES20.glGetBufferParameteri(target, pname);
    }

    public static int glGetBufferParameteri(int target, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static int glGetError() {
        int __result = GLES20.nglGetError();
        return __result;
    }

    static native int nglGetError();

    public static void glGetFloat(int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetFloatv(pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetFloatv(int var0, long var1);

    public static float glGetFloat(int pname) {
        FloatBuffer params = APIUtil.getBufferFloat();
        GLES20.nglGetFloatv(pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetFramebufferAttachmentParameter(int target, int attachment, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetFramebufferAttachmentParameteriv(int var0, int var1, int var2, long var3);

    @Deprecated
    public static int glGetFramebufferAttachmentParameter(int target, int attachment, int pname) {
        return GLES20.glGetFramebufferAttachmentParameteri(target, attachment, pname);
    }

    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetInteger(int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetIntegerv(pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetIntegerv(int var0, long var1);

    public static int glGetInteger(int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetIntegerv(pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetProgram(int program, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetProgramiv(int var0, int var1, long var2);

    @Deprecated
    public static int glGetProgram(int program, int pname) {
        return GLES20.glGetProgrami(program, pname);
    }

    public static int glGetProgrami(int program, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GLES20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog));
    }

    static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4);

    public static String glGetProgramInfoLog(int program, int bufsize) {
        IntBuffer infoLog_length = APIUtil.getLengths();
        ByteBuffer infoLog = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetProgramInfoLog(program, bufsize, MemoryUtil.getAddress0(infoLog_length), MemoryUtil.getAddress(infoLog));
        infoLog.limit(infoLog_length.get(0));
        return APIUtil.getString(infoLog);
    }

    public static void glGetRenderbufferParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetRenderbufferParameteriv(int var0, int var1, long var2);

    @Deprecated
    public static int glGetRenderbufferParameter(int target, int pname) {
        return GLES20.glGetRenderbufferParameteri(target, pname);
    }

    public static int glGetRenderbufferParameteri(int target, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetShader(int shader, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetShaderiv(int var0, int var1, long var2);

    @Deprecated
    public static int glGetShader(int shader, int pname) {
        return GLES20.glGetShaderi(shader, pname);
    }

    public static int glGetShaderi(int shader, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GLES20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog));
    }

    static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4);

    public static String glGetShaderInfoLog(int shader, int bufsize) {
        IntBuffer infoLog_length = APIUtil.getLengths();
        ByteBuffer infoLog = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetShaderInfoLog(shader, bufsize, MemoryUtil.getAddress0(infoLog_length), MemoryUtil.getAddress(infoLog));
        infoLog.limit(infoLog_length.get(0));
        return APIUtil.getString(infoLog);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        BufferChecks.checkBuffer(range, 2);
        BufferChecks.checkBuffer(precision, 1);
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.getAddress(range), MemoryUtil.getAddress(precision));
    }

    static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(source);
        GLES20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(source));
    }

    static native void nglGetShaderSource(int var0, int var1, long var2, long var4);

    public static String glGetShaderSource(int shader, int bufsize) {
        IntBuffer source_length = APIUtil.getLengths();
        ByteBuffer source = APIUtil.getBufferByte(bufsize);
        GLES20.nglGetShaderSource(shader, bufsize, MemoryUtil.getAddress0(source_length), MemoryUtil.getAddress(source));
        source.limit(source_length.get(0));
        return APIUtil.getString(source);
    }

    public static String glGetString(int name) {
        String __result = GLES20.nglGetString(name);
        return __result;
    }

    static native String nglGetString(int var0);

    public static void glGetTexParameter(int target, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetTexParameterfv(int var0, int var1, long var2);

    public static float glGetTexParameterf(int target, int pname) {
        FloatBuffer params = APIUtil.getBufferFloat();
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetTexParameter(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetTexParameteriv(int var0, int var1, long var2);

    public static int glGetTexParameteri(int target, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetUniform(int program, int location, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetUniformfv(program, location, MemoryUtil.getAddress(params));
    }

    static native void nglGetUniformfv(int var0, int var1, long var2);

    public static void glGetUniform(int program, int location, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES20.nglGetUniformiv(program, location, MemoryUtil.getAddress(params));
    }

    static native void nglGetUniformiv(int var0, int var1, long var2);

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        BufferChecks.checkBuffer(name, 1);
        BufferChecks.checkNullTerminated(name);
        int __result = GLES20.nglGetUniformLocation(program, MemoryUtil.getAddress(name));
        return __result;
    }

    static native int nglGetUniformLocation(int var0, long var1);

    public static int glGetUniformLocation(int program, CharSequence name) {
        int __result = GLES20.nglGetUniformLocation(program, APIUtil.getBufferNT(name));
        return __result;
    }

    public static void glGetVertexAttrib(int index, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetVertexAttribfv(int var0, int var1, long var2);

    public static void glGetVertexAttrib(int index, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetVertexAttribiv(int var0, int var1, long var2);

    public static ByteBuffer glGetVertexAttribPointer(int index, int pname, long result_size) {
        ByteBuffer __result = GLES20.nglGetVertexAttribPointerv(index, pname, result_size);
        return LWJGLUtil.CHECKS && __result == null ? null : __result.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexAttribPointerv(int var0, int var1, long var2);

    public static void glHint(int target, int mode) {
        GLES20.nglHint(target, mode);
    }

    static native void nglHint(int var0, int var1);

    public static boolean glIsBuffer(int buffer) {
        boolean __result = GLES20.nglIsBuffer(buffer);
        return __result;
    }

    static native boolean nglIsBuffer(int var0);

    public static boolean glIsEnabled(int cap) {
        boolean __result = GLES20.nglIsEnabled(cap);
        return __result;
    }

    static native boolean nglIsEnabled(int var0);

    public static boolean glIsFramebuffer(int framebuffer) {
        boolean __result = GLES20.nglIsFramebuffer(framebuffer);
        return __result;
    }

    static native boolean nglIsFramebuffer(int var0);

    public static boolean glIsProgram(int program) {
        boolean __result = GLES20.nglIsProgram(program);
        return __result;
    }

    static native boolean nglIsProgram(int var0);

    public static boolean glIsRenderbuffer(int renderbuffer) {
        boolean __result = GLES20.nglIsRenderbuffer(renderbuffer);
        return __result;
    }

    static native boolean nglIsRenderbuffer(int var0);

    public static boolean glIsShader(int shader) {
        boolean __result = GLES20.nglIsShader(shader);
        return __result;
    }

    static native boolean nglIsShader(int var0);

    public static boolean glIsTexture(int texture) {
        boolean __result = GLES20.nglIsTexture(texture);
        return __result;
    }

    static native boolean nglIsTexture(int var0);

    public static void glLineWidth(float width) {
        GLES20.nglLineWidth(width);
    }

    static native void nglLineWidth(float var0);

    public static void glLinkProgram(int program) {
        GLES20.nglLinkProgram(program);
    }

    static native void nglLinkProgram(int var0);

    public static void glPixelStorei(int pname, int param) {
        GLES20.nglPixelStorei(pname, param);
    }

    static native void nglPixelStorei(int var0, int var1);

    public static void glPolygonOffset(float factor, float units) {
        GLES20.nglPolygonOffset(factor, units);
    }

    static native void nglPolygonOffset(float var0, float var1);

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    static native void nglReadPixels(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glReleaseShaderCompiler() {
        GLES20.nglReleaseShaderCompiler();
    }

    static native void nglReleaseShaderCompiler();

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        GLES20.nglRenderbufferStorage(target, internalformat, width, height);
    }

    static native void nglRenderbufferStorage(int var0, int var1, int var2, int var3);

    public static void glSampleCoverage(float value, boolean invert) {
        GLES20.nglSampleCoverage(value, invert);
    }

    static native void nglSampleCoverage(float var0, boolean var1);

    public static void glScissor(int x, int y, int width, int height) {
        GLES20.nglScissor(x, y, width, height);
    }

    static native void nglScissor(int var0, int var1, int var2, int var3);

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        BufferChecks.checkDirect(shaders);
        BufferChecks.checkDirect(binary);
        GLES20.nglShaderBinary(shaders.remaining(), MemoryUtil.getAddress(shaders), binaryformat, MemoryUtil.getAddress(binary), binary.remaining());
    }

    static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6);

    public static void glShaderSource(int shader, ByteBuffer string) {
        BufferChecks.checkDirect(string);
        GLES20.nglShaderSource(shader, 1, MemoryUtil.getAddress(string), string.remaining());
    }

    static native void nglShaderSource(int var0, int var1, long var2, int var4);

    public static void glShaderSource(int shader, CharSequence string) {
        GLES20.nglShaderSource(shader, 1, APIUtil.getBuffer(string), string.length());
    }

    public static void glShaderSource(int shader, CharSequence[] strings) {
        BufferChecks.checkArray(strings);
        GLES20.nglShaderSource3(shader, strings.length, APIUtil.getBuffer(strings), APIUtil.getLengths(strings));
    }

    static native void nglShaderSource3(int var0, int var1, long var2, long var4);

    public static void glStencilFunc(int func, int ref, int mask) {
        GLES20.nglStencilFunc(func, ref, mask);
    }

    static native void nglStencilFunc(int var0, int var1, int var2);

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GLES20.nglStencilFuncSeparate(face, func, ref, mask);
    }

    static native void nglStencilFuncSeparate(int var0, int var1, int var2, int var3);

    public static void glStencilMask(int mask) {
        GLES20.nglStencilMask(mask);
    }

    static native void nglStencilMask(int var0);

    public static void glStencilMaskSeparate(int face, int mask) {
        GLES20.nglStencilMaskSeparate(face, mask);
    }

    static native void nglStencilMaskSeparate(int var0, int var1);

    public static void glStencilOp(int fail, int zfail, int zpass) {
        GLES20.nglStencilOp(fail, zfail, zpass);
    }

    static native void nglStencilOp(int var0, int var1, int var2);

    public static void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GLES20.nglStencilOpSeparate(face, fail, zfail, zpass);
    }

    static native void nglStencilOpSeparate(int var0, int var1, int var2, int var3);

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage2DStorage(pixels, format, type, width, height));
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    static native void nglTexImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glTexParameterf(int target, int pname, float param) {
        GLES20.nglTexParameterf(target, pname, param);
    }

    static native void nglTexParameterf(int var0, int var1, float var2);

    public static void glTexParameter(int target, int pname, FloatBuffer param) {
        BufferChecks.checkBuffer(param, 4);
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.getAddress(param));
    }

    static native void nglTexParameterfv(int var0, int var1, long var2);

    public static void glTexParameteri(int target, int pname, int param) {
        GLES20.nglTexParameteri(target, pname, param);
    }

    static native void nglTexParameteri(int var0, int var1, int var2);

    public static void glTexParameter(int target, int pname, IntBuffer param) {
        BufferChecks.checkBuffer(param, 4);
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.getAddress(param));
    }

    static native void nglTexParameteriv(int var0, int var1, long var2);

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, 1));
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.getAddress(pixels));
    }

    static native void nglTexSubImage2D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glUniform1f(int location, float x) {
        GLES20.nglUniform1f(location, x);
    }

    static native void nglUniform1f(int var0, float var1);

    public static void glUniform1(int location, FloatBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform1fv(location, v.remaining(), MemoryUtil.getAddress(v));
    }

    static native void nglUniform1fv(int var0, int var1, long var2);

    public static void glUniform1i(int location, int x) {
        GLES20.nglUniform1i(location, x);
    }

    static native void nglUniform1i(int var0, int var1);

    public static void glUniform1(int location, IntBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform1iv(location, v.remaining(), MemoryUtil.getAddress(v));
    }

    static native void nglUniform1iv(int var0, int var1, long var2);

    public static void glUniform2f(int location, float x, float y) {
        GLES20.nglUniform2f(location, x, y);
    }

    static native void nglUniform2f(int var0, float var1, float var2);

    public static void glUniform2(int location, FloatBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform2fv(location, v.remaining() >> 1, MemoryUtil.getAddress(v));
    }

    static native void nglUniform2fv(int var0, int var1, long var2);

    public static void glUniform2i(int location, int x, int y) {
        GLES20.nglUniform2i(location, x, y);
    }

    static native void nglUniform2i(int var0, int var1, int var2);

    public static void glUniform2(int location, IntBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform2iv(location, v.remaining() >> 1, MemoryUtil.getAddress(v));
    }

    static native void nglUniform2iv(int var0, int var1, long var2);

    public static void glUniform3f(int location, float x, float y, float z) {
        GLES20.nglUniform3f(location, x, y, z);
    }

    static native void nglUniform3f(int var0, float var1, float var2, float var3);

    public static void glUniform3(int location, FloatBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform3fv(location, v.remaining() / 3, MemoryUtil.getAddress(v));
    }

    static native void nglUniform3fv(int var0, int var1, long var2);

    public static void glUniform3i(int location, int x, int y, int z) {
        GLES20.nglUniform3i(location, x, y, z);
    }

    static native void nglUniform3i(int var0, int var1, int var2, int var3);

    public static void glUniform3(int location, IntBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform3iv(location, v.remaining() / 3, MemoryUtil.getAddress(v));
    }

    static native void nglUniform3iv(int var0, int var1, long var2);

    public static void glUniform4f(int location, float x, float y, float z, float w) {
        GLES20.nglUniform4f(location, x, y, z, w);
    }

    static native void nglUniform4f(int var0, float var1, float var2, float var3, float var4);

    public static void glUniform4(int location, FloatBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform4fv(location, v.remaining() >> 2, MemoryUtil.getAddress(v));
    }

    static native void nglUniform4fv(int var0, int var1, long var2);

    public static void glUniform4i(int location, int x, int y, int z, int w) {
        GLES20.nglUniform4i(location, x, y, z, w);
    }

    static native void nglUniform4i(int var0, int var1, int var2, int var3, int var4);

    public static void glUniform4(int location, IntBuffer v) {
        BufferChecks.checkDirect(v);
        GLES20.nglUniform4iv(location, v.remaining() >> 2, MemoryUtil.getAddress(v));
    }

    static native void nglUniform4iv(int var0, int var1, long var2);

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES20.nglUniformMatrix2fv(location, matrices.remaining() >> 2, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES20.nglUniformMatrix3fv(location, matrices.remaining() / 9, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES20.nglUniformMatrix4fv(location, matrices.remaining() >> 4, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3);

    public static void glUseProgram(int program) {
        GLES20.nglUseProgram(program);
    }

    static native void nglUseProgram(int var0);

    public static void glValidateProgram(int program) {
        GLES20.nglValidateProgram(program);
    }

    static native void nglValidateProgram(int var0);

    public static void glVertexAttrib1f(int indx, float x) {
        GLES20.nglVertexAttrib1f(indx, x);
    }

    static native void nglVertexAttrib1f(int var0, float var1);

    public static void glVertexAttrib1(int indx, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 1);
        GLES20.nglVertexAttrib1fv(indx, MemoryUtil.getAddress(values));
    }

    static native void nglVertexAttrib1fv(int var0, long var1);

    public static void glVertexAttrib2f(int indx, float x, float y) {
        GLES20.nglVertexAttrib2f(indx, x, y);
    }

    static native void nglVertexAttrib2f(int var0, float var1, float var2);

    public static void glVertexAttrib2(int indx, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 2);
        GLES20.nglVertexAttrib2fv(indx, MemoryUtil.getAddress(values));
    }

    static native void nglVertexAttrib2fv(int var0, long var1);

    public static void glVertexAttrib3f(int indx, float x, float y, float z) {
        GLES20.nglVertexAttrib3f(indx, x, y, z);
    }

    static native void nglVertexAttrib3f(int var0, float var1, float var2, float var3);

    public static void glVertexAttrib3(int indx, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 3);
        GLES20.nglVertexAttrib3fv(indx, MemoryUtil.getAddress(values));
    }

    static native void nglVertexAttrib3fv(int var0, long var1);

    public static void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        GLES20.nglVertexAttrib4f(indx, x, y, z, w);
    }

    static native void nglVertexAttrib4f(int var0, float var1, float var2, float var3, float var4);

    public static void glVertexAttrib4(int indx, FloatBuffer values) {
        BufferChecks.checkBuffer(values, 4);
        GLES20.nglVertexAttrib4fv(indx, MemoryUtil.getAddress(values));
    }

    static native void nglVertexAttrib4fv(int var0, long var1);

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, FloatBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES20.nglVertexAttribPointer(index, size, 5126, normalized, stride, MemoryUtil.getAddress(buffer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ByteBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES20.nglVertexAttribPointer(index, size, unsigned ? 5121 : 5120, normalized, stride, MemoryUtil.getAddress(buffer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, IntBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES20.nglVertexAttribPointer(index, size, unsigned ? 5125 : 5124, normalized, stride, MemoryUtil.getAddress(buffer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ShortBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES20.nglVertexAttribPointer(index, size, unsigned ? 5123 : 5122, normalized, stride, MemoryUtil.getAddress(buffer));
    }

    static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long buffer_buffer_offset) {
        GLChecks.ensureArrayVBOenabled();
        GLES20.nglVertexAttribPointerBO(index, size, type, normalized, stride, buffer_buffer_offset);
    }

    static native void nglVertexAttribPointerBO(int var0, int var1, int var2, boolean var3, int var4, long var5);

    public static void glViewport(int x, int y, int width, int height) {
        GLES20.nglViewport(x, y, width, height);
    }

    static native void nglViewport(int var0, int var1, int var2, int var3);
}

