/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.GLChecks;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLSync;
import org.lwjgl.opengles.StateTracker;

public final class GLES30 {
    public static final int GL_READ_BUFFER = 3074;
    public static final int GL_UNPACK_ROW_LENGTH = 3314;
    public static final int GL_UNPACK_SKIP_ROWS = 3315;
    public static final int GL_UNPACK_SKIP_PIXELS = 3316;
    public static final int GL_PACK_ROW_LENGTH = 3330;
    public static final int GL_PACK_SKIP_ROWS = 3331;
    public static final int GL_PACK_SKIP_PIXELS = 3332;
    public static final int GL_COLOR = 6144;
    public static final int GL_DEPTH = 6145;
    public static final int GL_STENCIL = 6146;
    public static final int GL_RED = 6403;
    public static final int GL_RGB8 = 32849;
    public static final int GL_RGBA8 = 32856;
    public static final int GL_RGB10_A2 = 32857;
    public static final int GL_TEXTURE_BINDING_3D = 32874;
    public static final int GL_PACK_SKIP_IMAGES = 32875;
    public static final int GL_PACK_IMAGE_HEIGHT = 32876;
    public static final int GL_UNPACK_SKIP_IMAGES = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT = 32878;
    public static final int GL_TEXTURE_3D = 32879;
    public static final int GL_TEXTURE_WRAP_R = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE = 32883;
    public static final int GL_UNSIGNED_INT_2_10_10_10_REV = 33640;
    public static final int GL_MAX_ELEMENTS_VERTICES = 33000;
    public static final int GL_MAX_ELEMENTS_INDICES = 33001;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_BASE_LEVEL = 33084;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_MIN = 32775;
    public static final int GL_MAX = 32776;
    public static final int GL_DEPTH_COMPONENT24 = 33190;
    public static final int GL_MAX_TEXTURE_LOD_BIAS = 34045;
    public static final int GL_TEXTURE_COMPARE_MODE = 34892;
    public static final int GL_TEXTURE_COMPARE_FUNC = 34893;
    public static final int GL_CURRENT_QUERY = 34917;
    public static final int GL_QUERY_RESULT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE = 34919;
    public static final int GL_BUFFER_MAPPED = 35004;
    public static final int GL_BUFFER_MAP_POINTER = 35005;
    public static final int GL_STREAM_READ = 35041;
    public static final int GL_STREAM_COPY = 35042;
    public static final int GL_STATIC_READ = 35045;
    public static final int GL_STATIC_COPY = 35046;
    public static final int GL_DYNAMIC_READ = 35049;
    public static final int GL_DYNAMIC_COPY = 35050;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_PIXEL_PACK_BUFFER = 35051;
    public static final int GL_PIXEL_UNPACK_BUFFER = 35052;
    public static final int GL_PIXEL_PACK_BUFFER_BINDING = 35053;
    public static final int GL_PIXEL_UNPACK_BUFFER_BINDING = 35055;
    public static final int GL_FLOAT_MAT2x3 = 35685;
    public static final int GL_FLOAT_MAT2x4 = 35686;
    public static final int GL_FLOAT_MAT3x2 = 35687;
    public static final int GL_FLOAT_MAT3x4 = 35688;
    public static final int GL_FLOAT_MAT4x2 = 35689;
    public static final int GL_FLOAT_MAT4x3 = 35690;
    public static final int GL_SRGB = 35904;
    public static final int GL_SRGB8 = 35905;
    public static final int GL_SRGB8_ALPHA8 = 35907;
    public static final int GL_COMPARE_REF_TO_TEXTURE = 34894;
    public static final int GL_MAJOR_VERSION = 33307;
    public static final int GL_MINOR_VERSION = 33308;
    public static final int GL_NUM_EXTENSIONS = 33309;
    public static final int GL_RGBA32F = 34836;
    public static final int GL_RGB32F = 34837;
    public static final int GL_RGBA16F = 34842;
    public static final int GL_RGB16F = 34843;
    public static final int GL_VERTEX_ATTRIB_ARRAY_INTEGER = 35069;
    public static final int GL_MAX_ARRAY_TEXTURE_LAYERS = 35071;
    public static final int GL_MIN_PROGRAM_TEXEL_OFFSET = 35076;
    public static final int GL_MAX_PROGRAM_TEXEL_OFFSET = 35077;
    public static final int GL_MAX_VARYING_COMPONENTS = 35659;
    public static final int GL_TEXTURE_2D_ARRAY = 35866;
    public static final int GL_TEXTURE_BINDING_2D_ARRAY = 35869;
    public static final int GL_R11F_G11F_B10F = 35898;
    public static final int GL_UNSIGNED_INT_10F_11F_11F_REV = 35899;
    public static final int GL_RGB9_E5 = 35901;
    public static final int GL_UNSIGNED_INT_5_9_9_9_REV = 35902;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 35958;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 35967;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 35976;
    public static final int GL_RASTERIZER_DISCARD = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 35979;
    public static final int GL_INTERLEAVED_ATTRIBS = 35980;
    public static final int GL_SEPARATE_ATTRIBS = 35981;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 35983;
    public static final int GL_RGBA32UI = 36208;
    public static final int GL_RGB32UI = 36209;
    public static final int GL_RGBA16UI = 36214;
    public static final int GL_RGB16UI = 36215;
    public static final int GL_RGBA8UI = 36220;
    public static final int GL_RGB8UI = 36221;
    public static final int GL_RGBA32I = 36226;
    public static final int GL_RGB32I = 36227;
    public static final int GL_RGBA16I = 36232;
    public static final int GL_RGB16I = 36233;
    public static final int GL_RGBA8I = 36238;
    public static final int GL_RGB8I = 36239;
    public static final int GL_RED_INTEGER = 36244;
    public static final int GL_RGB_INTEGER = 36248;
    public static final int GL_RGBA_INTEGER = 36249;
    public static final int GL_SAMPLER_2D_ARRAY = 36289;
    public static final int GL_SAMPLER_2D_ARRAY_SHADOW = 36292;
    public static final int GL_SAMPLER_CUBE_SHADOW = 36293;
    public static final int GL_UNSIGNED_INT_VEC2 = 36294;
    public static final int GL_UNSIGNED_INT_VEC3 = 36295;
    public static final int GL_UNSIGNED_INT_VEC4 = 36296;
    public static final int GL_INT_SAMPLER_2D = 36298;
    public static final int GL_INT_SAMPLER_3D = 36299;
    public static final int GL_INT_SAMPLER_CUBE = 36300;
    public static final int GL_INT_SAMPLER_2D_ARRAY = 36303;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D = 36306;
    public static final int GL_UNSIGNED_INT_SAMPLER_3D = 36307;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE = 36308;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 36311;
    public static final int GL_BUFFER_ACCESS_FLAGS = 37151;
    public static final int GL_BUFFER_MAP_LENGTH = 37152;
    public static final int GL_BUFFER_MAP_OFFSET = 37153;
    public static final int GL_DEPTH_COMPONENT32F = 36012;
    public static final int GL_DEPTH32F_STENCIL8 = 36013;
    public static final int GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 36269;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public static final int GL_FRAMEBUFFER_DEFAULT = 33304;
    public static final int GL_FRAMEBUFFER_UNDEFINED = 33305;
    public static final int GL_DEPTH_STENCIL_ATTACHMENT = 33306;
    public static final int GL_DEPTH_STENCIL = 34041;
    public static final int GL_UNSIGNED_INT_24_8 = 34042;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_UNSIGNED_NORMALIZED = 35863;
    public static final int GL_DRAW_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL_RENDERBUFFER_SAMPLES = 36011;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_MAX_COLOR_ATTACHMENTS = 36063;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_COLOR_ATTACHMENT4 = 36068;
    public static final int GL_COLOR_ATTACHMENT5 = 36069;
    public static final int GL_COLOR_ATTACHMENT6 = 36070;
    public static final int GL_COLOR_ATTACHMENT7 = 36071;
    public static final int GL_COLOR_ATTACHMENT8 = 36072;
    public static final int GL_COLOR_ATTACHMENT9 = 36073;
    public static final int GL_COLOR_ATTACHMENT10 = 36074;
    public static final int GL_COLOR_ATTACHMENT11 = 36075;
    public static final int GL_COLOR_ATTACHMENT12 = 36076;
    public static final int GL_COLOR_ATTACHMENT13 = 36077;
    public static final int GL_COLOR_ATTACHMENT14 = 36078;
    public static final int GL_COLOR_ATTACHMENT15 = 36079;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_HALF_FLOAT = 5131;
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public static final int GL_RG = 33319;
    public static final int GL_RG_INTEGER = 33320;
    public static final int GL_R8 = 33321;
    public static final int GL_RG8 = 33323;
    public static final int GL_R16F = 33325;
    public static final int GL_R32F = 33326;
    public static final int GL_RG16F = 33327;
    public static final int GL_RG32F = 33328;
    public static final int GL_R8I = 33329;
    public static final int GL_R8UI = 33330;
    public static final int GL_R16I = 33331;
    public static final int GL_R16UI = 33332;
    public static final int GL_R32I = 33333;
    public static final int GL_R32UI = 33334;
    public static final int GL_RG8I = 33335;
    public static final int GL_RG8UI = 33336;
    public static final int GL_RG16I = 33337;
    public static final int GL_RG16UI = 33338;
    public static final int GL_RG32I = 33339;
    public static final int GL_RG32UI = 33340;
    public static final int GL_VERTEX_ARRAY_BINDING = 34229;
    public static final int GL_R8_SNORM = 36756;
    public static final int GL_RG8_SNORM = 36757;
    public static final int GL_RGB8_SNORM = 36758;
    public static final int GL_RGBA8_SNORM = 36759;
    public static final int GL_SIGNED_NORMALIZED = 36764;
    public static final int GL_PRIMITIVE_RESTART_FIXED_INDEX = 36201;
    public static final int GL_COPY_READ_BUFFER = 36662;
    public static final int GL_COPY_WRITE_BUFFER = 36663;
    public static final int GL_COPY_READ_BUFFER_BINDING = 36662;
    public static final int GL_COPY_WRITE_BUFFER_BINDING = 36663;
    public static final int GL_UNIFORM_BUFFER = 35345;
    public static final int GL_UNIFORM_BUFFER_BINDING = 35368;
    public static final int GL_UNIFORM_BUFFER_START = 35369;
    public static final int GL_UNIFORM_BUFFER_SIZE = 35370;
    public static final int GL_MAX_VERTEX_UNIFORM_BLOCKS = 35371;
    public static final int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 35373;
    public static final int GL_MAX_COMBINED_UNIFORM_BLOCKS = 35374;
    public static final int GL_MAX_UNIFORM_BUFFER_BINDINGS = 35375;
    public static final int GL_MAX_UNIFORM_BLOCK_SIZE = 35376;
    public static final int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 35377;
    public static final int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 35379;
    public static final int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 35380;
    public static final int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 35381;
    public static final int GL_ACTIVE_UNIFORM_BLOCKS = 35382;
    public static final int GL_UNIFORM_TYPE = 35383;
    public static final int GL_UNIFORM_SIZE = 35384;
    public static final int GL_UNIFORM_NAME_LENGTH = 35385;
    public static final int GL_UNIFORM_BLOCK_INDEX = 35386;
    public static final int GL_UNIFORM_OFFSET = 35387;
    public static final int GL_UNIFORM_ARRAY_STRIDE = 35388;
    public static final int GL_UNIFORM_MATRIX_STRIDE = 35389;
    public static final int GL_UNIFORM_IS_ROW_MAJOR = 35390;
    public static final int GL_UNIFORM_BLOCK_BINDING = 35391;
    public static final int GL_UNIFORM_BLOCK_DATA_SIZE = 35392;
    public static final int GL_UNIFORM_BLOCK_NAME_LENGTH = 35393;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 35394;
    public static final int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 35395;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 35396;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 35398;
    public static final int GL_INVALID_INDEX = -1;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 35070;
    public static final int GL_ANY_SAMPLES_PASSED = 35887;
    public static final int GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;
    public static final int GL_SAMPLER_BINDING = 35097;
    public static final int GL_RGB10_A2UI = 36975;
    public static final int GL_TEXTURE_SWIZZLE_R = 36418;
    public static final int GL_TEXTURE_SWIZZLE_G = 36419;
    public static final int GL_TEXTURE_SWIZZLE_B = 36420;
    public static final int GL_TEXTURE_SWIZZLE_A = 36421;
    public static final int GL_GREEN = 6404;
    public static final int GL_BLUE = 6405;
    public static final int GL_INT_2_10_10_10_REV = 36255;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_TEXTURE_IMMUTABLE_FORMAT = 37167;
    public static final int GL_MAX_ELEMENT_INDEX = 36203;
    public static final int GL_NUM_SAMPLE_COUNTS = 37760;

    private GLES30() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glReadBuffer(int mode) {
        GLES30.nglReadBuffer(mode);
    }

    static native void nglReadBuffer(int var0);

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5121, MemoryUtil.getAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5125, MemoryUtil.getAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawRangeElements(mode, start, end, indices.remaining(), 5123, MemoryUtil.getAddress(indices));
    }

    static native void nglDrawRangeElements(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDrawRangeElements(int mode, int start, int end, int indices_count, int type, long indices_buffer_offset) {
        GLChecks.ensureElementVBOenabled();
        GLES30.nglDrawRangeElementsBO(mode, start, end, indices_count, type, indices_buffer_offset);
    }

    static native void nglDrawRangeElementsBO(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        GLES30.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        GLES30.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        GLES30.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        if (pixels != null) {
            BufferChecks.checkBuffer(pixels, GLChecks.calculateTexImage3DStorage(pixels, format, type, width, height, depth));
        }
        GLES30.nglTexImage3D(target, level, internalFormat, width, height, depth, border, format, type, MemoryUtil.getAddressSafe(pixels));
    }

    static native void nglTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, long pixels_buffer_offset) {
        GLChecks.ensureUnpackPBOenabled();
        GLES30.nglTexImage3DBO(target, level, internalFormat, width, height, depth, border, format, type, pixels_buffer_offset);
    }

    static native void nglTexImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkBuffer(pixels, GLChecks.calculateImageStorage(pixels, format, type, width, height, depth));
        GLES30.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(pixels));
    }

    static native void nglTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels_buffer_offset) {
        GLChecks.ensureUnpackPBOenabled();
        GLES30.nglTexSubImage3DBO(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels_buffer_offset);
    }

    static native void nglTexSubImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        GLES30.nglCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }

    static native void nglCopyTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, ByteBuffer data) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkDirect(data);
        GLES30.nglCompressedTexImage3D(target, level, internalformat, width, height, depth, border, data.remaining(), MemoryUtil.getAddress(data));
    }

    static native void nglCompressedTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int data_imageSize, long data_buffer_offset) {
        GLChecks.ensureUnpackPBOenabled();
        GLES30.nglCompressedTexImage3DBO(target, level, internalformat, width, height, depth, border, data_imageSize, data_buffer_offset);
    }

    static native void nglCompressedTexImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        GLChecks.ensureUnpackPBOdisabled();
        BufferChecks.checkDirect(data);
        GLES30.nglCompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.getAddress(data));
    }

    static native void nglCompressedTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int data_imageSize, long data_buffer_offset) {
        GLChecks.ensureUnpackPBOenabled();
        GLES30.nglCompressedTexSubImage3DBO(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data_imageSize, data_buffer_offset);
    }

    static native void nglCompressedTexSubImage3DBO(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static void glGenQueries(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GLES30.nglGenQueries(ids.remaining(), MemoryUtil.getAddress(ids));
    }

    static native void nglGenQueries(int var0, long var1);

    public static int glGenQueries() {
        IntBuffer ids = APIUtil.getBufferInt();
        GLES30.nglGenQueries(1, MemoryUtil.getAddress(ids));
        return ids.get(0);
    }

    public static void glDeleteQueries(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GLES30.nglDeleteQueries(ids.remaining(), MemoryUtil.getAddress(ids));
    }

    static native void nglDeleteQueries(int var0, long var1);

    public static void glDeleteQueries(int id) {
        GLES30.nglDeleteQueries(1, APIUtil.getInt(id));
    }

    public static boolean glIsQuery(int id) {
        boolean __result = GLES30.nglIsQuery(id);
        return __result;
    }

    static native boolean nglIsQuery(int var0);

    public static void glBeginQuery(int target, int id) {
        GLES30.nglBeginQuery(target, id);
    }

    static native void nglBeginQuery(int var0, int var1);

    public static void glEndQuery(int target) {
        GLES30.nglEndQuery(target);
    }

    static native void nglEndQuery(int var0);

    public static void glGetQuery(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES30.nglGetQueryiv(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetQueryiv(int var0, int var1, long var2);

    public static int glGetQueryi(int target, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetQueryiv(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetQueryObjectu(int id, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetQueryObjectuiv(int var0, int var1, long var2);

    public static int glGetQueryObjectui(int id, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetQueryObjectuiv(id, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static boolean glUnmapBuffer(int target) {
        boolean __result = GLES30.nglUnmapBuffer(target);
        return __result;
    }

    static native boolean nglUnmapBuffer(int var0);

    public static ByteBuffer glGetBufferPointer(int target, int pname) {
        ByteBuffer __result = GLES30.nglGetBufferPointerv(target, pname, GLES20.glGetBufferParameteri(target, 34660));
        return LWJGLUtil.CHECKS && __result == null ? null : __result.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetBufferPointerv(int var0, int var1, long var2);

    public static void glDrawBuffers(IntBuffer buffers) {
        BufferChecks.checkDirect(buffers);
        GLES30.nglDrawBuffers(buffers.remaining(), MemoryUtil.getAddress(buffers));
    }

    static native void nglDrawBuffers(int var0, long var1);

    public static void glDrawBuffers(int buffer) {
        GLES30.nglDrawBuffers(1, APIUtil.getInt(buffer));
    }

    public static void glUniformMatrix2x3(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix2x3fv(location, matrices.remaining() / 6, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix2x3fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x2(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix3x2fv(location, matrices.remaining() / 6, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix3x2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix2x4(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix2x4fv(location, matrices.remaining() >> 3, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix2x4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x2(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix4x2fv(location, matrices.remaining() >> 3, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix4x2fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix3x4(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix3x4fv(location, matrices.remaining() / 12, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix3x4fv(int var0, int var1, boolean var2, long var3);

    public static void glUniformMatrix4x3(int location, boolean transpose, FloatBuffer matrices) {
        BufferChecks.checkDirect(matrices);
        GLES30.nglUniformMatrix4x3fv(location, matrices.remaining() / 12, transpose, MemoryUtil.getAddress(matrices));
    }

    static native void nglUniformMatrix4x3fv(int var0, int var1, boolean var2, long var3);

    public static void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        GLES30.nglBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }

    static native void nglBlitFramebuffer(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        GLES30.nglRenderbufferStorageMultisample(target, samples, internalformat, width, height);
    }

    static native void nglRenderbufferStorageMultisample(int var0, int var1, int var2, int var3, int var4);

    public static void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer) {
        GLES30.nglFramebufferTextureLayer(target, attachment, texture, level, layer);
    }

    static native void nglFramebufferTextureLayer(int var0, int var1, int var2, int var3, int var4);

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer __result = GLES30.nglMapBufferRange(target, offset, length, access, old_buffer);
        return LWJGLUtil.CHECKS && __result == null ? null : __result.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapBufferRange(int var0, long var1, long var3, int var5, ByteBuffer var6);

    public static void glFlushMappedBufferRange(int target, long offset, long length) {
        GLES30.nglFlushMappedBufferRange(target, offset, length);
    }

    static native void nglFlushMappedBufferRange(int var0, long var1, long var3);

    public static void glBindVertexArray(int array) {
        StateTracker.bindVAO(array);
        GLES30.nglBindVertexArray(array);
    }

    static native void nglBindVertexArray(int var0);

    public static void glDeleteVertexArrays(IntBuffer arrays) {
        StateTracker.deleteVAO(arrays);
        BufferChecks.checkDirect(arrays);
        GLES30.nglDeleteVertexArrays(arrays.remaining(), MemoryUtil.getAddress(arrays));
    }

    static native void nglDeleteVertexArrays(int var0, long var1);

    public static void glDeleteVertexArrays(int array) {
        StateTracker.deleteVAO(array);
        GLES30.nglDeleteVertexArrays(1, APIUtil.getInt(array));
    }

    public static void glGenVertexArrays(IntBuffer arrays) {
        BufferChecks.checkDirect(arrays);
        GLES30.nglGenVertexArrays(arrays.remaining(), MemoryUtil.getAddress(arrays));
    }

    static native void nglGenVertexArrays(int var0, long var1);

    public static int glGenVertexArrays() {
        IntBuffer arrays = APIUtil.getBufferInt();
        GLES30.nglGenVertexArrays(1, MemoryUtil.getAddress(arrays));
        return arrays.get(0);
    }

    public static boolean glIsVertexArray(int array) {
        boolean __result = GLES30.nglIsVertexArray(array);
        return __result;
    }

    static native boolean nglIsVertexArray(int var0);

    public static void glGetInteger(int value, int index, IntBuffer data) {
        BufferChecks.checkBuffer(data, 4);
        GLES30.nglGetIntegeri_v(value, index, MemoryUtil.getAddress(data));
    }

    static native void nglGetIntegeri_v(int var0, int var1, long var2);

    public static int glGetInteger(int value, int index) {
        IntBuffer data = APIUtil.getBufferInt();
        GLES30.nglGetIntegeri_v(value, index, MemoryUtil.getAddress(data));
        return data.get(0);
    }

    public static void glBeginTransformFeedback(int primitiveMode) {
        GLES30.nglBeginTransformFeedback(primitiveMode);
    }

    static native void nglBeginTransformFeedback(int var0);

    public static void glEndTransformFeedback() {
        GLES30.nglEndTransformFeedback();
    }

    static native void nglEndTransformFeedback();

    public static void glBindBufferRange(int target, int index, int buffer, long offset, long size) {
        GLES30.nglBindBufferRange(target, index, buffer, offset, size);
    }

    static native void nglBindBufferRange(int var0, int var1, int var2, long var3, long var5);

    public static void glBindBufferBase(int target, int index, int buffer) {
        GLES30.nglBindBufferBase(target, index, buffer);
    }

    static native void nglBindBufferBase(int var0, int var1, int var2);

    public static void glTransformFeedbackVaryings(int program, int count, ByteBuffer varyings, int bufferMode) {
        BufferChecks.checkDirect(varyings);
        BufferChecks.checkNullTerminated(varyings, count);
        GLES30.nglTransformFeedbackVaryings(program, count, MemoryUtil.getAddress(varyings), bufferMode);
    }

    static native void nglTransformFeedbackVaryings(int var0, int var1, long var2, int var4);

    public static void glTransformFeedbackVaryings(int program, CharSequence[] varyings, int bufferMode) {
        BufferChecks.checkArray(varyings);
        GLES30.nglTransformFeedbackVaryings(program, varyings.length, APIUtil.getBufferNT(varyings), bufferMode);
    }

    public static void glGetTransformFeedbackVarying(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        GLES30.nglGetTransformFeedbackVarying(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name));
    }

    static native void nglGetTransformFeedbackVarying(int var0, int var1, int var2, long var3, long var5, long var7, long var9);

    public static String glGetTransformFeedbackVarying(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        IntBuffer name_length = APIUtil.getLengths();
        ByteBuffer name = APIUtil.getBufferByte(bufSize);
        GLES30.nglGetTransformFeedbackVarying(program, index, bufSize, MemoryUtil.getAddress0(name_length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name));
        name.limit(name_length.get(0));
        return APIUtil.getString(name);
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ByteBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.getAddress(buffer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, IntBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.getAddress(buffer));
    }

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, ShortBuffer buffer) {
        GLChecks.ensureArrayVBOdisabled();
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getTracker().glVertexAttribPointer_buffer[index] = buffer;
        }
        GLES30.nglVertexAttribIPointer(index, size, type, stride, MemoryUtil.getAddress(buffer));
    }

    static native void nglVertexAttribIPointer(int var0, int var1, int var2, int var3, long var4);

    public static void glVertexAttribIPointer(int index, int size, int type, int stride, long buffer_buffer_offset) {
        GLChecks.ensureArrayVBOenabled();
        GLES30.nglVertexAttribIPointerBO(index, size, type, stride, buffer_buffer_offset);
    }

    static native void nglVertexAttribIPointerBO(int var0, int var1, int var2, int var3, long var4);

    public static void glGetVertexAttribI(int index, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglGetVertexAttribIiv(index, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetVertexAttribIiv(int var0, int var1, long var2);

    public static void glGetVertexAttribIu(int index, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglGetVertexAttribIuiv(index, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetVertexAttribIuiv(int var0, int var1, long var2);

    public static void glVertexAttribI4i(int index, int x, int y, int z, int w) {
        GLES30.nglVertexAttribI4i(index, x, y, z, w);
    }

    static native void nglVertexAttribI4i(int var0, int var1, int var2, int var3, int var4);

    public static void glVertexAttribI4ui(int index, int x, int y, int z, int w) {
        GLES30.nglVertexAttribI4ui(index, x, y, z, w);
    }

    static native void nglVertexAttribI4ui(int var0, int var1, int var2, int var3, int var4);

    public static void glVertexAttribI4(int index, IntBuffer v) {
        BufferChecks.checkBuffer(v, 4);
        GLES30.nglVertexAttribI4iv(index, MemoryUtil.getAddress(v));
    }

    static native void nglVertexAttribI4iv(int var0, long var1);

    public static void glVertexAttribI4u(int index, IntBuffer v) {
        BufferChecks.checkBuffer(v, 4);
        GLES30.nglVertexAttribI4uiv(index, MemoryUtil.getAddress(v));
    }

    static native void nglVertexAttribI4uiv(int var0, long var1);

    public static void glGetUniformu(int program, int location, IntBuffer params) {
        BufferChecks.checkDirect(params);
        GLES30.nglGetUniformuiv(program, location, MemoryUtil.getAddress(params));
    }

    static native void nglGetUniformuiv(int var0, int var1, long var2);

    public static int glGetFragDataLocation(int program, ByteBuffer name) {
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int __result = GLES30.nglGetFragDataLocation(program, MemoryUtil.getAddress(name));
        return __result;
    }

    static native int nglGetFragDataLocation(int var0, long var1);

    public static int glGetFragDataLocation(int program, CharSequence name) {
        int __result = GLES30.nglGetFragDataLocation(program, APIUtil.getBufferNT(name));
        return __result;
    }

    public static void glUniform1ui(int location, int v0) {
        GLES30.nglUniform1ui(location, v0);
    }

    static native void nglUniform1ui(int var0, int var1);

    public static void glUniform2ui(int location, int v0, int v1) {
        GLES30.nglUniform2ui(location, v0, v1);
    }

    static native void nglUniform2ui(int var0, int var1, int var2);

    public static void glUniform3ui(int location, int v0, int v1, int v2) {
        GLES30.nglUniform3ui(location, v0, v1, v2);
    }

    static native void nglUniform3ui(int var0, int var1, int var2, int var3);

    public static void glUniform4ui(int location, int v0, int v1, int v2, int v3) {
        GLES30.nglUniform4ui(location, v0, v1, v2, v3);
    }

    static native void nglUniform4ui(int var0, int var1, int var2, int var3, int var4);

    public static void glUniform1u(int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        GLES30.nglUniform1uiv(location, value.remaining(), MemoryUtil.getAddress(value));
    }

    static native void nglUniform1uiv(int var0, int var1, long var2);

    public static void glUniform2u(int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        GLES30.nglUniform2uiv(location, value.remaining() >> 1, MemoryUtil.getAddress(value));
    }

    static native void nglUniform2uiv(int var0, int var1, long var2);

    public static void glUniform3u(int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        GLES30.nglUniform3uiv(location, value.remaining() / 3, MemoryUtil.getAddress(value));
    }

    static native void nglUniform3uiv(int var0, int var1, long var2);

    public static void glUniform4u(int location, IntBuffer value) {
        BufferChecks.checkDirect(value);
        GLES30.nglUniform4uiv(location, value.remaining() >> 2, MemoryUtil.getAddress(value));
    }

    static native void nglUniform4uiv(int var0, int var1, long var2);

    public static void glClearBuffer(int buffer, int drawbuffer, FloatBuffer value) {
        BufferChecks.checkBuffer(value, 4);
        GLES30.nglClearBufferfv(buffer, drawbuffer, MemoryUtil.getAddress(value));
    }

    static native void nglClearBufferfv(int var0, int var1, long var2);

    public static void glClearBuffer(int buffer, int drawbuffer, IntBuffer value) {
        BufferChecks.checkBuffer(value, 4);
        GLES30.nglClearBufferiv(buffer, drawbuffer, MemoryUtil.getAddress(value));
    }

    static native void nglClearBufferiv(int var0, int var1, long var2);

    public static void glClearBufferu(int buffer, int drawbuffer, IntBuffer value) {
        BufferChecks.checkBuffer(value, 4);
        GLES30.nglClearBufferuiv(buffer, drawbuffer, MemoryUtil.getAddress(value));
    }

    static native void nglClearBufferuiv(int var0, int var1, long var2);

    public static void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil) {
        GLES30.nglClearBufferfi(buffer, drawbuffer, depth, stencil);
    }

    static native void nglClearBufferfi(int var0, int var1, float var2, int var3);

    public static String glGetStringi(int name, int index) {
        String __result = GLES30.nglGetStringi(name, index);
        return __result;
    }

    static native String nglGetStringi(int var0, int var1);

    public static void glCopyBufferSubData(int readtarget, int writetarget, long readoffset, long writeoffset, long size) {
        GLES30.nglCopyBufferSubData(readtarget, writetarget, readoffset, writeoffset, size);
    }

    static native void nglCopyBufferSubData(int var0, int var1, long var2, long var4, long var6);

    public static void glGetUniformIndices(int program, ByteBuffer uniformNames, IntBuffer uniformIndices) {
        BufferChecks.checkDirect(uniformNames);
        BufferChecks.checkNullTerminated(uniformNames, uniformIndices.remaining());
        BufferChecks.checkDirect(uniformIndices);
        GLES30.nglGetUniformIndices(program, uniformIndices.remaining(), MemoryUtil.getAddress(uniformNames), MemoryUtil.getAddress(uniformIndices));
    }

    static native void nglGetUniformIndices(int var0, int var1, long var2, long var4);

    public static void glGetUniformIndices(int program, CharSequence[] uniformNames, IntBuffer uniformIndices) {
        BufferChecks.checkArray(uniformNames);
        BufferChecks.checkBuffer(uniformIndices, uniformNames.length);
        GLES30.nglGetUniformIndices(program, uniformNames.length, APIUtil.getBufferNT(uniformNames), MemoryUtil.getAddress(uniformIndices));
    }

    public static void glGetActiveUniforms(int program, IntBuffer uniformIndices, int pname, IntBuffer params) {
        BufferChecks.checkDirect(uniformIndices);
        BufferChecks.checkBuffer(params, uniformIndices.remaining());
        GLES30.nglGetActiveUniformsiv(program, uniformIndices.remaining(), MemoryUtil.getAddress(uniformIndices), pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetActiveUniformsiv(int var0, int var1, long var2, int var4, long var5);

    public static int glGetActiveUniformsi(int program, int uniformIndex, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetActiveUniformsiv(program, 1, MemoryUtil.getAddress(params.put(1, uniformIndex), 1), pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static int glGetUniformBlockIndex(int program, ByteBuffer uniformBlockName) {
        BufferChecks.checkDirect(uniformBlockName);
        BufferChecks.checkNullTerminated(uniformBlockName);
        int __result = GLES30.nglGetUniformBlockIndex(program, MemoryUtil.getAddress(uniformBlockName));
        return __result;
    }

    static native int nglGetUniformBlockIndex(int var0, long var1);

    public static int glGetUniformBlockIndex(int program, CharSequence uniformBlockName) {
        int __result = GLES30.nglGetUniformBlockIndex(program, APIUtil.getBufferNT(uniformBlockName));
        return __result;
    }

    public static void glGetActiveUniformBlock(int program, int uniformBlockIndex, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 16);
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetActiveUniformBlockiv(int var0, int var1, int var2, long var3);

    public static int glGetActiveUniformBlocki(int program, int uniformBlockIndex, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetActiveUniformBlockiv(program, uniformBlockIndex, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetActiveUniformBlockName(int program, int uniformBlockIndex, IntBuffer length, ByteBuffer uniformBlockName) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(uniformBlockName);
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, uniformBlockName.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(uniformBlockName));
    }

    static native void nglGetActiveUniformBlockName(int var0, int var1, int var2, long var3, long var5);

    public static String glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize) {
        IntBuffer uniformBlockName_length = APIUtil.getLengths();
        ByteBuffer uniformBlockName = APIUtil.getBufferByte(bufSize);
        GLES30.nglGetActiveUniformBlockName(program, uniformBlockIndex, bufSize, MemoryUtil.getAddress0(uniformBlockName_length), MemoryUtil.getAddress(uniformBlockName));
        uniformBlockName.limit(uniformBlockName_length.get(0));
        return APIUtil.getString(uniformBlockName);
    }

    public static void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding) {
        GLES30.nglUniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
    }

    static native void nglUniformBlockBinding(int var0, int var1, int var2);

    public static void glDrawArraysInstanced(int mode, int first, int count, int primcount) {
        GLES30.nglDrawArraysInstanced(mode, first, count, primcount);
    }

    static native void nglDrawArraysInstanced(int var0, int var1, int var2, int var3);

    public static void glDrawElementsInstanced(int mode, ByteBuffer indices, int primcount) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5121, MemoryUtil.getAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, IntBuffer indices, int primcount) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5125, MemoryUtil.getAddress(indices), primcount);
    }

    public static void glDrawElementsInstanced(int mode, ShortBuffer indices, int primcount) {
        GLChecks.ensureElementVBOdisabled();
        BufferChecks.checkDirect(indices);
        GLES30.nglDrawElementsInstanced(mode, indices.remaining(), 5123, MemoryUtil.getAddress(indices), primcount);
    }

    static native void nglDrawElementsInstanced(int var0, int var1, int var2, long var3, int var5);

    public static void glDrawElementsInstanced(int mode, int indices_count, int type, long indices_buffer_offset, int primcount) {
        GLChecks.ensureElementVBOenabled();
        GLES30.nglDrawElementsInstancedBO(mode, indices_count, type, indices_buffer_offset, primcount);
    }

    static native void nglDrawElementsInstancedBO(int var0, int var1, int var2, long var3, int var5);

    public static GLSync glFenceSync(int condition, int flags) {
        GLSync __result = new GLSync(GLES30.nglFenceSync(condition, flags));
        return __result;
    }

    static native long nglFenceSync(int var0, int var1);

    public static boolean glIsSync(GLSync sync) {
        boolean __result = GLES30.nglIsSync(sync.getPointer());
        return __result;
    }

    static native boolean nglIsSync(long var0);

    public static void glDeleteSync(GLSync sync) {
        GLES30.nglDeleteSync(sync.getPointer());
    }

    static native void nglDeleteSync(long var0);

    public static int glClientWaitSync(GLSync sync, int flags, long timeout) {
        int __result = GLES30.nglClientWaitSync(sync.getPointer(), flags, timeout);
        return __result;
    }

    static native int nglClientWaitSync(long var0, int var2, long var3);

    public static void glWaitSync(GLSync sync, int flags, long timeout) {
        GLES30.nglWaitSync(sync.getPointer(), flags, timeout);
    }

    static native void nglWaitSync(long var0, int var2, long var3);

    public static void glGetInteger64(int pname, LongBuffer data) {
        BufferChecks.checkBuffer(data, 1);
        GLES30.nglGetInteger64v(pname, MemoryUtil.getAddress(data));
    }

    static native void nglGetInteger64v(int var0, long var1);

    public static long glGetInteger64(int pname) {
        LongBuffer data = APIUtil.getBufferLong();
        GLES30.nglGetInteger64v(pname, MemoryUtil.getAddress(data));
        return data.get(0);
    }

    public static void glGetInteger64(int value, int index, LongBuffer data) {
        BufferChecks.checkBuffer(data, 4);
        GLES30.nglGetInteger64i_v(value, index, MemoryUtil.getAddress(data));
    }

    static native void nglGetInteger64i_v(int var0, int var1, long var2);

    public static long glGetInteger64(int value, int index) {
        LongBuffer data = APIUtil.getBufferLong();
        GLES30.nglGetInteger64i_v(value, index, MemoryUtil.getAddress(data));
        return data.get(0);
    }

    public static void glGetSync(GLSync sync, int pname, IntBuffer length, IntBuffer values) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(values);
        GLES30.nglGetSynciv(sync.getPointer(), pname, values.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(values));
    }

    static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6);

    public static int glGetSynci(GLSync sync, int pname) {
        IntBuffer values = APIUtil.getBufferInt();
        GLES30.nglGetSynciv(sync.getPointer(), pname, 1, 0L, MemoryUtil.getAddress(values));
        return values.get(0);
    }

    public static void glGetBufferParameter(int target, int pname, LongBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetBufferParameteri64v(int var0, int var1, long var2);

    public static long glGetBufferParameteri64(int target, int pname) {
        LongBuffer params = APIUtil.getBufferLong();
        GLES30.nglGetBufferParameteri64v(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGenSamplers(IntBuffer samplers) {
        BufferChecks.checkDirect(samplers);
        GLES30.nglGenSamplers(samplers.remaining(), MemoryUtil.getAddress(samplers));
    }

    static native void nglGenSamplers(int var0, long var1);

    public static int glGenSamplers() {
        IntBuffer samplers = APIUtil.getBufferInt();
        GLES30.nglGenSamplers(1, MemoryUtil.getAddress(samplers));
        return samplers.get(0);
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        BufferChecks.checkDirect(samplers);
        GLES30.nglDeleteSamplers(samplers.remaining(), MemoryUtil.getAddress(samplers));
    }

    static native void nglDeleteSamplers(int var0, long var1);

    public static void glDeleteSamplers(int sampler) {
        GLES30.nglDeleteSamplers(1, APIUtil.getInt(sampler));
    }

    public static boolean glIsSampler(int sampler) {
        boolean __result = GLES30.nglIsSampler(sampler);
        return __result;
    }

    static native boolean nglIsSampler(int var0);

    public static void glBindSampler(int unit, int sampler) {
        GLES30.nglBindSampler(unit, sampler);
    }

    static native void nglBindSampler(int var0, int var1);

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        GLES30.nglSamplerParameteri(sampler, pname, param);
    }

    static native void nglSamplerParameteri(int var0, int var1, int var2);

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        GLES30.nglSamplerParameterf(sampler, pname, param);
    }

    static native void nglSamplerParameterf(int var0, int var1, float var2);

    public static void glSamplerParameter(int sampler, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglSamplerParameteriv(sampler, pname, MemoryUtil.getAddress(params));
    }

    static native void nglSamplerParameteriv(int var0, int var1, long var2);

    public static void glSamplerParameter(int sampler, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglSamplerParameterfv(sampler, pname, MemoryUtil.getAddress(params));
    }

    static native void nglSamplerParameterfv(int var0, int var1, long var2);

    public static void glGetSamplerParameter(int sampler, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetSamplerParameteriv(int var0, int var1, long var2);

    public static int glGetSamplerParameteri(int sampler, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetSamplerParameter(int sampler, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 4);
        GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetSamplerParameterfv(int var0, int var1, long var2);

    public static float glGetSamplerParameterf(int sampler, int pname) {
        FloatBuffer params = APIUtil.getBufferFloat();
        GLES30.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glVertexAttribDivisor(int index, int divisor) {
        GLES30.nglVertexAttribDivisor(index, divisor);
    }

    static native void nglVertexAttribDivisor(int var0, int var1);

    public static void glBindTransformFeedback(int target, int id) {
        GLES30.nglBindTransformFeedback(target, id);
    }

    static native void nglBindTransformFeedback(int var0, int var1);

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GLES30.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.getAddress(ids));
    }

    static native void nglDeleteTransformFeedbacks(int var0, long var1);

    public static void glDeleteTransformFeedbacks(int id) {
        GLES30.nglDeleteTransformFeedbacks(1, APIUtil.getInt(id));
    }

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        BufferChecks.checkDirect(ids);
        GLES30.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.getAddress(ids));
    }

    static native void nglGenTransformFeedbacks(int var0, long var1);

    public static int glGenTransformFeedbacks() {
        IntBuffer ids = APIUtil.getBufferInt();
        GLES30.nglGenTransformFeedbacks(1, MemoryUtil.getAddress(ids));
        return ids.get(0);
    }

    public static boolean glIsTransformFeedback(int id) {
        boolean __result = GLES30.nglIsTransformFeedback(id);
        return __result;
    }

    static native boolean nglIsTransformFeedback(int var0);

    public static void glPauseTransformFeedback() {
        GLES30.nglPauseTransformFeedback();
    }

    static native void nglPauseTransformFeedback();

    public static void glResumeTransformFeedback() {
        GLES30.nglResumeTransformFeedback();
    }

    static native void nglResumeTransformFeedback();

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(binaryFormat, 1);
        BufferChecks.checkDirect(binary);
        GLES30.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(binaryFormat), MemoryUtil.getAddress(binary));
    }

    static native void nglGetProgramBinary(int var0, int var1, long var2, long var4, long var6);

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        BufferChecks.checkDirect(binary);
        GLES30.nglProgramBinary(program, binaryFormat, MemoryUtil.getAddress(binary), binary.remaining());
    }

    static native void nglProgramBinary(int var0, int var1, long var2, int var4);

    public static void glProgramParameteri(int program, int pname, int value) {
        GLES30.nglProgramParameteri(program, pname, value);
    }

    static native void nglProgramParameteri(int var0, int var1, int var2);

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        BufferChecks.checkDirect(attachments);
        GLES30.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.getAddress(attachments));
    }

    static native void nglInvalidateFramebuffer(int var0, int var1, long var2);

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        BufferChecks.checkDirect(attachments);
        GLES30.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.getAddress(attachments), x, y, width, height);
    }

    static native void nglInvalidateSubFramebuffer(int var0, int var1, long var2, int var4, int var5, int var6, int var7);

    public static void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        GLES30.nglTexStorage2D(target, levels, internalformat, width, height);
    }

    static native void nglTexStorage2D(int var0, int var1, int var2, int var3, int var4);

    public static void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth) {
        GLES30.nglTexStorage3D(target, levels, internalformat, width, height, depth);
    }

    static native void nglTexStorage3D(int var0, int var1, int var2, int var3, int var4, int var5);

    public static void glGetInternalformat(int target, int internalformat, int pname, IntBuffer params) {
        BufferChecks.checkDirect(params);
        GLES30.nglGetInternalformativ(target, internalformat, pname, params.remaining(), MemoryUtil.getAddress(params));
    }

    static native void nglGetInternalformativ(int var0, int var1, int var2, int var3, long var4);

    public static int glGetInternalformat(int target, int internalformat, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        GLES30.nglGetInternalformativ(target, internalformat, pname, 1, MemoryUtil.getAddress(params));
        return params.get(0);
    }
}

