/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.GLChecks;

public final class NVGetTexImage {
    public static final int GL_TEXTURE_WIDTH_NV = 4096;
    public static final int GL_TEXTURE_HEIGHT_NV = 4097;
    public static final int GL_TEXTURE_INTERNAL_FORMAT_NV = 4099;
    public static final int GL_TEXTURE_COMPONENTS_NV = 4099;
    public static final int GL_TEXTURE_BORDER_NV = 4101;
    public static final int GL_TEXTURE_RED_SIZE_NV = 32860;
    public static final int GL_TEXTURE_GREEN_SIZE_NV = 32861;
    public static final int GL_TEXTURE_BLUE_SIZE_NV = 32862;
    public static final int GL_TEXTURE_ALPHA_SIZE_NV = 32863;
    public static final int GL_TEXTURE_LUMINANCE_SIZE_NV = 32864;
    public static final int GL_TEXTURE_INTENSITY_SIZE_NV = 32865;
    public static final int GL_TEXTURE_DEPTH_NV = 32881;
    public static final int GL_TEXTURE_COMPRESSED_IMAGE_SIZE_NV = 34464;
    public static final int GL_TEXTURE_COMPRESSED_NV = 34465;
    public static final int GL_TEXTURE_DEPTH_SIZE_NV = 34890;

    private NVGetTexImage() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glGetTexImageNV(int target, int level, int format, int type, ByteBuffer img) {
        BufferChecks.checkBuffer(img, GLChecks.calculateImageStorage(img, format, type, 1, 1, 1));
        NVGetTexImage.nglGetTexImageNV(target, level, format, type, MemoryUtil.getAddress(img));
    }

    public static void glGetTexImageNV(int target, int level, int format, int type, FloatBuffer img) {
        BufferChecks.checkBuffer(img, GLChecks.calculateImageStorage(img, format, type, 1, 1, 1));
        NVGetTexImage.nglGetTexImageNV(target, level, format, type, MemoryUtil.getAddress(img));
    }

    public static void glGetTexImageNV(int target, int level, int format, int type, IntBuffer img) {
        BufferChecks.checkBuffer(img, GLChecks.calculateImageStorage(img, format, type, 1, 1, 1));
        NVGetTexImage.nglGetTexImageNV(target, level, format, type, MemoryUtil.getAddress(img));
    }

    public static void glGetTexImageNV(int target, int level, int format, int type, ShortBuffer img) {
        BufferChecks.checkBuffer(img, GLChecks.calculateImageStorage(img, format, type, 1, 1, 1));
        NVGetTexImage.nglGetTexImageNV(target, level, format, type, MemoryUtil.getAddress(img));
    }

    static native void nglGetTexImageNV(int var0, int var1, int var2, int var3, long var4);

    public static void glGetCompressedTexImageNV(int target, int level, ByteBuffer img) {
        BufferChecks.checkDirect(img);
        NVGetTexImage.nglGetCompressedTexImageNV(target, level, MemoryUtil.getAddress(img));
    }

    static native void nglGetCompressedTexImageNV(int var0, int var1, long var2);

    public static void glGetTexLevelParameterNV(int target, int level, int pname, FloatBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        NVGetTexImage.nglGetTexLevelParameterfvNV(target, level, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetTexLevelParameterfvNV(int var0, int var1, int var2, long var3);

    public static float glGetTexLevelParameterfNV(int target, int level, int pname) {
        FloatBuffer params = APIUtil.getBufferFloat();
        NVGetTexImage.nglGetTexLevelParameterfvNV(target, level, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGetTexLevelParameterNV(int target, int level, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        NVGetTexImage.nglGetTexLevelParameterivNV(target, level, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetTexLevelParameterivNV(int var0, int var1, int var2, long var3);

    public static int glGetTexLevelParameteriNV(int target, int level, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        NVGetTexImage.nglGetTexLevelParameterivNV(target, level, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }
}

