/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class OESFramebufferObject {
    public static final int GL_FRAMEBUFFER_OES = 36160;
    public static final int GL_RENDERBUFFER_OES = 36161;
    public static final int GL_DEPTH_COMPONENT16_OES = 33189;
    public static final int GL_RGBA4_OES = 32854;
    public static final int GL_RGB5_A1_OES = 32855;
    public static final int GL_RGB565_OES = 36194;
    public static final int GL_STENCIL_INDEX1_OES = 36166;
    public static final int GL_STENCIL_INDEX4_OES = 36167;
    public static final int GL_STENCIL_INDEX8_OES = 36168;
    public static final int GL_RENDERBUFFER_WIDTH_OES = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT_OES = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT_OES = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE_OES = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE_OES = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE_OES = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE_OES = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE_OES = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE_OES = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES = 36051;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = 36052;
    public static final int GL_COLOR_ATTACHMENT0_OES = 36064;
    public static final int GL_DEPTH_ATTACHMENT_OES = 36096;
    public static final int GL_STENCIL_ATTACHMENT_OES = 36128;
    public static final int GL_NONE_OES = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE_OES = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES = 36057;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES = 36058;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED_OES = 36061;
    public static final int GL_FRAMEBUFFER_BINDING_OES = 36006;
    public static final int GL_RENDERBUFFER_BINDING_OES = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE_OES = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION_OES = 1286;

    private OESFramebufferObject() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static boolean glIsRenderbufferOES(int renderbuffer) {
        boolean __result = OESFramebufferObject.nglIsRenderbufferOES(renderbuffer);
        return __result;
    }

    static native boolean nglIsRenderbufferOES(int var0);

    public static void glBindRenderbufferOES(int target, int renderbuffer) {
        OESFramebufferObject.nglBindRenderbufferOES(target, renderbuffer);
    }

    static native void nglBindRenderbufferOES(int var0, int var1);

    public static void glDeleteRenderbuffersOES(IntBuffer renderbuffers) {
        BufferChecks.checkDirect(renderbuffers);
        OESFramebufferObject.nglDeleteRenderbuffersOES(renderbuffers.remaining(), MemoryUtil.getAddress(renderbuffers));
    }

    static native void nglDeleteRenderbuffersOES(int var0, long var1);

    public static void glDeleteRenderbuffersOES(int renderbuffer) {
        OESFramebufferObject.nglDeleteRenderbuffersOES(1, APIUtil.getInt(renderbuffer));
    }

    public static void glGenRenderbuffersOES(IntBuffer renderbuffers) {
        BufferChecks.checkDirect(renderbuffers);
        OESFramebufferObject.nglGenRenderbuffersOES(renderbuffers.remaining(), MemoryUtil.getAddress(renderbuffers));
    }

    static native void nglGenRenderbuffersOES(int var0, long var1);

    public static int glGenRenderbuffersOES() {
        IntBuffer renderbuffers = APIUtil.getBufferInt();
        OESFramebufferObject.nglGenRenderbuffersOES(1, MemoryUtil.getAddress(renderbuffers));
        return renderbuffers.get(0);
    }

    public static void glRenderbufferStorageOES(int target, int internalformat, int width, int height) {
        OESFramebufferObject.nglRenderbufferStorageOES(target, internalformat, width, height);
    }

    static native void nglRenderbufferStorageOES(int var0, int var1, int var2, int var3);

    public static void glGetRenderbufferParameterOES(int target, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        OESFramebufferObject.nglGetRenderbufferParameterivOES(target, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetRenderbufferParameterivOES(int var0, int var1, long var2);

    @Deprecated
    public static int glGetRenderbufferParameterOES(int target, int pname) {
        return OESFramebufferObject.glGetRenderbufferParameteriOES(target, pname);
    }

    public static int glGetRenderbufferParameteriOES(int target, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        OESFramebufferObject.nglGetRenderbufferParameterivOES(target, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static boolean glIsFramebufferOES(int framebuffer) {
        boolean __result = OESFramebufferObject.nglIsFramebufferOES(framebuffer);
        return __result;
    }

    static native boolean nglIsFramebufferOES(int var0);

    public static void glBindFramebufferOES(int target, int framebuffer) {
        OESFramebufferObject.nglBindFramebufferOES(target, framebuffer);
    }

    static native void nglBindFramebufferOES(int var0, int var1);

    public static void glDeleteFramebuffersOES(IntBuffer framebuffers) {
        BufferChecks.checkDirect(framebuffers);
        OESFramebufferObject.nglDeleteFramebuffersOES(framebuffers.remaining(), MemoryUtil.getAddress(framebuffers));
    }

    static native void nglDeleteFramebuffersOES(int var0, long var1);

    public static void glDeleteFramebuffersOES(int framebuffer) {
        OESFramebufferObject.nglDeleteFramebuffersOES(1, APIUtil.getInt(framebuffer));
    }

    public static void glGenFramebuffersOES(IntBuffer framebuffers) {
        BufferChecks.checkDirect(framebuffers);
        OESFramebufferObject.nglGenFramebuffersOES(framebuffers.remaining(), MemoryUtil.getAddress(framebuffers));
    }

    static native void nglGenFramebuffersOES(int var0, long var1);

    public static int glGenFramebuffersOES() {
        IntBuffer framebuffers = APIUtil.getBufferInt();
        OESFramebufferObject.nglGenFramebuffersOES(1, MemoryUtil.getAddress(framebuffers));
        return framebuffers.get(0);
    }

    public static int glCheckFramebufferStatusOES(int target) {
        int __result = OESFramebufferObject.nglCheckFramebufferStatusOES(target);
        return __result;
    }

    static native int nglCheckFramebufferStatusOES(int var0);

    public static void glFramebufferTexture2DOES(int target, int attachment, int textarget, int texture, int level) {
        OESFramebufferObject.nglFramebufferTexture2DOES(target, attachment, textarget, texture, level);
    }

    static native void nglFramebufferTexture2DOES(int var0, int var1, int var2, int var3, int var4);

    public static void glFramebufferRenderbufferOES(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        OESFramebufferObject.nglFramebufferRenderbufferOES(target, attachment, renderbuffertarget, renderbuffer);
    }

    static native void nglFramebufferRenderbufferOES(int var0, int var1, int var2, int var3);

    public static void glGetFramebufferAttachmentParameterOES(int target, int attachment, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        OESFramebufferObject.nglGetFramebufferAttachmentParameterivOES(target, attachment, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetFramebufferAttachmentParameterivOES(int var0, int var1, int var2, long var3);

    @Deprecated
    public static int glGetFramebufferAttachmentParameterOES(int target, int attachment, int pname) {
        return OESFramebufferObject.glGetFramebufferAttachmentParameteriOES(target, attachment, pname);
    }

    public static int glGetFramebufferAttachmentParameteriOES(int target, int attachment, int pname) {
        IntBuffer params = APIUtil.getBufferInt();
        OESFramebufferObject.nglGetFramebufferAttachmentParameterivOES(target, attachment, pname, MemoryUtil.getAddress(params));
        return params.get(0);
    }

    public static void glGenerateMipmapOES(int target) {
        OESFramebufferObject.nglGenerateMipmapOES(target);
    }

    static native void nglGenerateMipmapOES(int var0);
}

