/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.GLChecks;

public final class QCOMExtendedGet {
    public static final int GL_TEXTURE_WIDTH_QCOM = 35794;
    public static final int GL_TEXTURE_HEIGHT_QCOM = 35795;
    public static final int GL_TEXTURE_DEPTH_QCOM = 35796;
    public static final int GL_TEXTURE_INTERNAL_FORMAT_QCOM = 35797;
    public static final int GL_TEXTURE_FORMAT_QCOM = 35798;
    public static final int GL_TEXTURE_TYPE_QCOM = 35799;
    public static final int GL_TEXTURE_IMAGE_VALID_QCOM = 35800;
    public static final int GL_TEXTURE_NUM_LEVELS_QCOM = 35801;
    public static final int GL_TEXTURE_TARGET_QCOM = 35802;
    public static final int GL_TEXTURE_OBJECT_VALID_QCOM = 35803;
    public static final int GL_STATE_RESTORE = 35804;

    private QCOMExtendedGet() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glExtGetTexturesQCOM(IntBuffer textures, IntBuffer numTextures) {
        BufferChecks.checkBuffer(textures, 1);
        BufferChecks.checkBuffer(numTextures, 1);
        QCOMExtendedGet.nglExtGetTexturesQCOM(MemoryUtil.getAddress(textures), textures.remaining(), MemoryUtil.getAddress(numTextures));
    }

    static native void nglExtGetTexturesQCOM(long var0, int var2, long var3);

    public static void glExtGetBuffersQCOM(IntBuffer buffers, IntBuffer numBuffers) {
        BufferChecks.checkBuffer(buffers, 1);
        BufferChecks.checkBuffer(numBuffers, 1);
        QCOMExtendedGet.nglExtGetBuffersQCOM(MemoryUtil.getAddress(buffers), buffers.remaining(), MemoryUtil.getAddress(numBuffers));
    }

    static native void nglExtGetBuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetRenderbuffersQCOM(IntBuffer renderbuffers, IntBuffer numRenderbuffers) {
        BufferChecks.checkBuffer(renderbuffers, 1);
        BufferChecks.checkBuffer(numRenderbuffers, 1);
        QCOMExtendedGet.nglExtGetRenderbuffersQCOM(MemoryUtil.getAddress(renderbuffers), renderbuffers.remaining(), MemoryUtil.getAddress(numRenderbuffers));
    }

    static native void nglExtGetRenderbuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetFramebuffersQCOM(IntBuffer framebuffers, IntBuffer numFramebuffers) {
        BufferChecks.checkBuffer(framebuffers, 1);
        BufferChecks.checkBuffer(numFramebuffers, 1);
        QCOMExtendedGet.nglExtGetFramebuffersQCOM(MemoryUtil.getAddress(framebuffers), framebuffers.remaining(), MemoryUtil.getAddress(numFramebuffers));
    }

    static native void nglExtGetFramebuffersQCOM(long var0, int var2, long var3);

    public static void glExtGetTexLevelParameterivQCOM(int texture, int face, int level, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        QCOMExtendedGet.nglExtGetTexLevelParameterivQCOM(texture, face, level, pname, MemoryUtil.getAddress(params));
    }

    static native void nglExtGetTexLevelParameterivQCOM(int var0, int var1, int var2, int var3, long var4);

    public static void glExtTexObjectStateOverrideiQCOM(int target, int pname, int param) {
        QCOMExtendedGet.nglExtTexObjectStateOverrideiQCOM(target, pname, param);
    }

    static native void nglExtTexObjectStateOverrideiQCOM(int var0, int var1, int var2);

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer texels) {
        BufferChecks.checkBuffer(texels, GLChecks.calculateImageStorage(texels, format, type, width, height, depth));
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(texels));
    }

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer texels) {
        BufferChecks.checkBuffer(texels, GLChecks.calculateImageStorage(texels, format, type, width, height, depth));
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(texels));
    }

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer texels) {
        BufferChecks.checkBuffer(texels, GLChecks.calculateImageStorage(texels, format, type, width, height, depth));
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(texels));
    }

    public static void glExtGetTexSubImageQCOM(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer texels) {
        BufferChecks.checkBuffer(texels, GLChecks.calculateImageStorage(texels, format, type, width, height, depth));
        QCOMExtendedGet.nglExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.getAddress(texels));
    }

    static native void nglExtGetTexSubImageQCOM(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    public static ByteBuffer glExtGetBufferPointervQCOM(int target, long result_size) {
        ByteBuffer __result = QCOMExtendedGet.nglExtGetBufferPointervQCOM(target, result_size);
        return LWJGLUtil.CHECKS && __result == null ? null : __result.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglExtGetBufferPointervQCOM(int var0, long var1);
}

