/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.GLES20;

public final class Util {
    private Util() {
    }

    public static void checkGLError() throws OpenGLException {
        int err = GLES20.glGetError();
        if (err != 0) {
            throw new OpenGLException(err);
        }
    }

    public static String translateGLErrorString(int error_code) {
        switch (error_code) {
            case 0: {
                return "No error";
            }
            case 1280: {
                return "Invalid enum";
            }
            case 1281: {
                return "Invalid value";
            }
            case 1282: {
                return "Invalid operation";
            }
            case 1285: {
                return "Out of memory";
            }
        }
        return null;
    }

    static void checkEGLError() throws LWJGLException {
        int err = EGL.eglGetError();
        if (err != 12288) {
            throw new LWJGLException(Util.translateEGLErrorString(err));
        }
    }

    static String translateEGLErrorString(int error_code) {
        switch (error_code) {
            case 12289: {
                return "EGL not initialized";
            }
            case 12290: {
                return "Bad access";
            }
            case 12291: {
                return "Bad allocation";
            }
            case 12292: {
                return "Bad attribute";
            }
            case 12293: {
                return "Bad config";
            }
            case 12294: {
                return "Bad EGL context";
            }
            case 12295: {
                return "Bad current EGL surface";
            }
            case 12296: {
                return "Bad EGL display";
            }
            case 12297: {
                return "Bad match";
            }
            case 12298: {
                return "Bad native pixmap";
            }
            case 12299: {
                return "Bad native window";
            }
            case 12300: {
                return "Bad parameter";
            }
            case 12301: {
                return "Bad EGL surface";
            }
            case 12302: {
                return "EGL context lost";
            }
        }
        return null;
    }
}

