/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.test.opengles.util.GLMatrix;
import org.lwjgl.test.opengles.util.Shader;
import org.lwjgl.test.opengles.util.ShaderProgram;
import org.lwjgl.util.vector.Matrix4f;

final class QuadRenderer {
    private final Shader vsh;
    private final Shader fsh;
    private final ShaderProgram program;
    private final int uniMVP;
    private final Matrix4f p = new Matrix4f();
    private final Matrix4f mv = new Matrix4f();
    private final Matrix4f mvp = new Matrix4f();
    private final FloatBuffer m4fBuffer = BufferUtils.createFloatBuffer(16);

    QuadRenderer() {
        this.vsh = new Shader(35633, "uniform highp mat4 MODEL_VIEW_PROJECTION_MATRIX;\nattribute highp vec2 vPosition;\nvoid main(void) {\n\tgl_Position = MODEL_VIEW_PROJECTION_MATRIX * vec4(vPosition, 0.0, 1.0);\n}");
        this.fsh = new Shader(35632, "void main(void) {\n\tgl_FragColor = vec4(1.0);\n}");
        this.program = new ShaderProgram(this.vsh, this.fsh);
        this.program.enable();
        this.uniMVP = this.program.getUniformLocation("MODEL_VIEW_PROJECTION_MATRIX");
        int vPosition = this.program.getAttributeLocation("vPosition");
        GLES20.glVertexAttribPointer(vPosition, 2, 5126, false, 0, 0L);
        GLES20.glEnableVertexAttribArray(vPosition);
    }

    void setMVPUniform() {
        GLMatrix.glMatrixMode(5889);
        GLMatrix.glGetMatrix(this.p);
        GLMatrix.glMatrixMode(5888);
        GLMatrix.glGetMatrix(this.mv);
        Matrix4f.mul(this.p, this.mv, this.mvp);
        this.mvp.store(this.m4fBuffer);
        this.m4fBuffer.flip();
        GLES20.glUniformMatrix4(this.uniMVP, false, this.m4fBuffer);
    }

    void cleanup() {
        this.program.destroy();
        this.fsh.destroy();
        this.vsh.destroy();
    }
}

