/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import org.lwjgl.opengles.GLES20;
import org.lwjgl.test.opengles.util.GLObject;
import org.lwjgl.test.opengles.util.Shader;

public class ShaderProgram
implements GLObject {
    private final int ID = GLES20.glCreateProgram();

    public ShaderProgram(Shader ... shaders) {
        for (Shader shader : shaders) {
            GLES20.glAttachShader(this.ID, shader.getID());
        }
        GLES20.glLinkProgram(this.ID);
        if (GLES20.glGetProgrami(this.ID, 35714) == 0) {
            this.printInfoLog();
            this.destroy();
            throw new RuntimeException("Failed to link a Shader Program: " + this.ID);
        }
    }

    public void validate() {
        boolean error;
        GLES20.glValidateProgram(this.ID);
        boolean bl = error = GLES20.glGetProgrami(this.ID, 35715) == 0;
        if (error) {
            this.printInfoLog();
            throw new RuntimeException("Failed to validate a Shader Program.");
        }
    }

    public int getID() {
        return this.ID;
    }

    public void destroy() {
        GLES20.glDeleteProgram(this.ID);
    }

    public void enable() {
        GLES20.glUseProgram(this.ID);
    }

    public static void disable() {
        GLES20.glUseProgram(0);
    }

    public int getUniformLocation(String uniform) {
        int location = GLES20.glGetUniformLocation(this.ID, uniform);
        if (location == -1) {
            throw new IllegalArgumentException("Invalid uniform name specified: " + uniform);
        }
        return location;
    }

    public int getAttributeLocation(String attrib) {
        int location = GLES20.glGetAttribLocation(this.ID, attrib);
        if (location == -1) {
            throw new IllegalArgumentException("Invalid attribute name specified: " + attrib);
        }
        return location;
    }

    private void printInfoLog() {
        int logLength = GLES20.glGetProgrami(this.ID, 35716);
        System.out.println(logLength);
        if (logLength <= 1) {
            return;
        }
        System.out.println("\nInfo Log of Shader Program: " + this.ID);
        System.out.println("-------------------");
        System.out.println(GLES20.glGetProgramInfoLog(this.ID, logLength));
        System.out.println("-------------------");
    }
}

