/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.test.opengles.util.BufferObjectArray;
import org.lwjgl.test.opengles.util.ImmediateModeBuffer;

public final class Sphere {
    public static final int GLU_SMOOTH = 100000;
    public static final int GLU_FLAT = 100001;
    public static final int GLU_NONE = 100002;
    public static final int GLU_POINT = 100010;
    public static final int GLU_LINE = 100011;
    public static final int GLU_FILL = 100012;
    public static final int GLU_SILHOUETTE = 100013;
    public static final int GLU_OUTSIDE = 100020;
    public static final int GLU_INSIDE = 100021;
    static final float PI = (float)Math.PI;
    private int drawStyle;
    private int orientation;
    private boolean textureFlag;
    private int normals;
    private BufferObjectArray bo;
    private final List<DrawCommand> drawCommands = new ArrayList<DrawCommand>(4);

    public Sphere() {
        this(100012, 100020, false, 100000);
    }

    public Sphere(int drawStyle, int orientation, boolean textureFlag, int normals) {
        this.setDrawStyle(drawStyle);
        this.setOrientation(orientation);
        this.setTextureFlag(textureFlag);
        this.setNormals(normals);
    }

    public Sphere(float radius, int slices, int stacks) {
        this();
        this.updateGeometry(radius, slices, stacks);
    }

    public Sphere(float radius, int slices, int stacks, int drawStyle, int orientation, boolean textureFlag, int normals) {
        this(drawStyle, orientation, textureFlag, normals);
        this.updateGeometry(radius, slices, stacks);
    }

    public void updateGeometry(float radius, int slices, int stacks) {
        if (this.bo != null) {
            this.destroy();
        }
        this.bo = new BufferObjectArray(35044, this.createBuffer(radius, slices, stacks));
    }

    public void bind() {
        this.bo.enable();
    }

    public void draw() {
        for (DrawCommand command : this.drawCommands) {
            command.draw();
        }
    }

    public void destroy() {
        this.bo.destroy();
        this.bo = null;
        this.drawCommands.clear();
    }

    public void setDrawStyle(int drawStyle) {
        switch (drawStyle) {
            case 100010: 
            case 100011: 
            case 100012: 
            case 100013: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid draw style specified: " + drawStyle);
            }
        }
        this.drawStyle = drawStyle;
    }

    public void setNormals(int normals) {
        switch (normals) {
            case 100000: 
            case 100001: 
            case 100002: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid normal kind specified: " + normals);
            }
        }
        this.normals = normals;
    }

    public void setOrientation(int orientation) {
        if (orientation != 100020 && orientation != 100021) {
            throw new IllegalArgumentException("Invalid orientation specified: " + orientation);
        }
        this.orientation = orientation;
    }

    public void setTextureFlag(boolean textureFlag) {
        this.textureFlag = textureFlag;
    }

    public int getDrawStyle() {
        return this.drawStyle;
    }

    public int getNormals() {
        return this.normals;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean getTextureFlag() {
        return this.textureFlag;
    }

    private static float sin(float r) {
        return (float)Math.sin(r);
    }

    private static float cos(float r) {
        return (float)Math.cos(r);
    }

    private int addDrawCommand(int mode, int first, int count) {
        this.drawCommands.add(new DrawCommand(mode, first, count));
        return count;
    }

    public FloatBuffer createBuffer(float radius, int slices, int stacks) {
        ImmediateModeBuffer imb;
        block28: {
            int lastDrawIndex;
            float dtheta;
            float drho;
            float nsign;
            boolean normals;
            block27: {
                float s;
                float rho;
                int imax;
                int imin;
                float z;
                float y;
                float x;
                float theta;
                int j;
                normals = this.normals != 100002;
                nsign = this.orientation == 100021 ? -1.0f : 1.0f;
                drho = (float)Math.PI / (float)stacks;
                dtheta = (float)Math.PI * 2 / (float)slices;
                imb = new ImmediateModeBuffer(16384);
                lastDrawIndex = 0;
                if (this.drawStyle != 100012) break block27;
                if (!this.textureFlag) {
                    lastDrawIndex += this.addDrawCommand(6, lastDrawIndex, slices + 2);
                    imb.glNormal3f(0.0f, 0.0f, 1.0f);
                    imb.glVertex3f(0.0f, 0.0f, nsign * radius);
                    for (j = 0; j <= slices; ++j) {
                        theta = j == slices ? 0.0f : (float)j * dtheta;
                        x = -Sphere.sin(theta) * Sphere.sin(drho);
                        y = Sphere.cos(theta) * Sphere.sin(drho);
                        z = nsign * Sphere.cos(drho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                    }
                }
                float ds = 1.0f / (float)slices;
                float dt = 1.0f / (float)stacks;
                float t = 1.0f;
                if (this.textureFlag) {
                    imin = 0;
                    imax = stacks;
                } else {
                    imin = 1;
                    imax = stacks - 1;
                }
                for (int i = imin; i < imax; ++i) {
                    lastDrawIndex += this.addDrawCommand(5, lastDrawIndex, (slices + 1) * 2);
                    rho = (float)i * drho;
                    s = 0.0f;
                    for (j = 0; j <= slices; ++j) {
                        theta = j == slices ? 0.0f : (float)j * dtheta;
                        x = -Sphere.sin(theta) * Sphere.sin(rho);
                        y = Sphere.cos(theta) * Sphere.sin(rho);
                        z = nsign * Sphere.cos(rho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        if (this.textureFlag) {
                            imb.glTexCoord2f(s, t);
                        }
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                        x = -Sphere.sin(theta) * Sphere.sin(rho + drho);
                        y = Sphere.cos(theta) * Sphere.sin(rho + drho);
                        z = nsign * Sphere.cos(rho + drho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        if (this.textureFlag) {
                            imb.glTexCoord2f(s, t - dt);
                        }
                        s += ds;
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                    }
                    t -= dt;
                }
                if (this.textureFlag) break block28;
                lastDrawIndex += this.addDrawCommand(6, lastDrawIndex, slices + 2);
                imb.glNormal3f(0.0f, 0.0f, -1.0f);
                imb.glVertex3f(0.0f, 0.0f, -radius * nsign);
                rho = (float)Math.PI - drho;
                s = 1.0f;
                for (j = slices; j >= 0; --j) {
                    theta = j == slices ? 0.0f : (float)j * dtheta;
                    x = -Sphere.sin(theta) * Sphere.sin(rho);
                    y = Sphere.cos(theta) * Sphere.sin(rho);
                    z = nsign * Sphere.cos(rho);
                    if (normals) {
                        imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                    }
                    s -= ds;
                    imb.glVertex3f(x * radius, y * radius, z * radius);
                }
                break block28;
            }
            if (this.drawStyle == 100011 || this.drawStyle == 100013) {
                float z;
                float y;
                float x;
                float theta;
                int j;
                float rho;
                int i;
                for (i = 1; i < stacks; ++i) {
                    lastDrawIndex += this.addDrawCommand(2, lastDrawIndex, slices);
                    rho = (float)i * drho;
                    for (j = 0; j < slices; ++j) {
                        theta = (float)j * dtheta;
                        x = Sphere.cos(theta) * Sphere.sin(rho);
                        y = Sphere.sin(theta) * Sphere.sin(rho);
                        z = Sphere.cos(rho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                    }
                }
                for (j = 0; j < slices; ++j) {
                    lastDrawIndex += this.addDrawCommand(3, lastDrawIndex, stacks + 1);
                    theta = (float)j * dtheta;
                    for (i = 0; i <= stacks; ++i) {
                        rho = (float)i * drho;
                        x = Sphere.cos(theta) * Sphere.sin(rho);
                        y = Sphere.sin(theta) * Sphere.sin(rho);
                        z = Sphere.cos(rho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                    }
                }
            } else if (this.drawStyle == 100010) {
                lastDrawIndex += this.addDrawCommand(0, lastDrawIndex, 2 + (stacks - 2) * slices);
                if (normals) {
                    imb.glNormal3f(0.0f, 0.0f, nsign);
                }
                imb.glVertex3f(0.0f, 0.0f, radius);
                if (normals) {
                    imb.glNormal3f(0.0f, 0.0f, -nsign);
                }
                imb.glVertex3f(0.0f, 0.0f, -radius);
                for (int i = 1; i < stacks - 1; ++i) {
                    float rho = (float)i * drho;
                    for (int j = 0; j < slices; ++j) {
                        float theta = (float)j * dtheta;
                        float x = Sphere.cos(theta) * Sphere.sin(rho);
                        float y = Sphere.sin(theta) * Sphere.sin(rho);
                        float z = Sphere.cos(rho);
                        if (normals) {
                            imb.glNormal3f(x * nsign, y * nsign, z * nsign);
                        }
                        imb.glVertex3f(x * radius, y * radius, z * radius);
                    }
                }
            }
        }
        return imb.getBuffer();
    }

    private static class DrawCommand {
        private int mode;
        private int first;
        private int count;

        private DrawCommand(int mode, int first, int count) {
            this.mode = mode;
            this.first = first;
            this.count = count;
        }

        void draw() {
            GLES20.glDrawArrays(this.mode, this.first, this.count);
        }
    }
}

