/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.AutoType;
import org.lwjgl.util.generator.BufferKind;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Extension;
import org.lwjgl.util.generator.GenerateAutos;
import org.lwjgl.util.generator.Helper;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NoErrorCheck;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.PostfixTranslator;
import org.lwjgl.util.generator.Private;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.StripPostfix;
import org.lwjgl.util.generator.TypeInfo;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opengl.GLreturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethodsGenerator {
    private static final String SAVED_PARAMETER_POSTFIX = "_saved";
    private static final Map<String, Pattern> postfixPatterns = new HashMap<String, Pattern>();

    public static void generateMethodsJava(ProcessingEnvironment env, TypeMap type_map, PrintWriter writer, TypeElement interface_decl, boolean generate_error_checks, boolean context_specific) {
        for (ExecutableElement method : Utils.getMethods(interface_decl)) {
            JavaMethodsGenerator.generateMethodJava(env, type_map, writer, interface_decl, method, generate_error_checks, context_specific);
        }
    }

    private static void generateMethodJava(ProcessingEnvironment env, TypeMap type_map, PrintWriter writer, TypeElement interface_decl, ExecutableElement method, boolean generate_error_checks, boolean context_specific) {
        writer.println();
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            if (method.getAnnotation(GenerateAutos.class) != null) {
                JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, TypeInfo.getDefaultTypeInfoMap(method), Mode.AUTOS, generate_error_checks, context_specific);
            }
            Collection<Map<VariableElement, TypeInfo>> cross_product = TypeInfo.getTypeInfoCrossProduct(type_map, method);
            for (Map<VariableElement, TypeInfo> typeinfos_instance : cross_product) {
                JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, typeinfos_instance, Mode.NORMAL, generate_error_checks, context_specific);
            }
        }
        if (method.getAnnotation(CachedResult.class) != null && !method.getAnnotation(CachedResult.class).isRange()) {
            JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, TypeInfo.getDefaultTypeInfoMap(method), Mode.CACHEDRESULT, generate_error_checks, context_specific);
        }
        Reuse reuse_annotation = method.getAnnotation(Reuse.class);
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        if (alt_annotation == null || alt_annotation.nativeAlt() && !alt_annotation.skipNative()) {
            if (alt_annotation != null && method.getSimpleName().toString().equals(alt_annotation.value())) {
                throw new RuntimeException("An alternate function with native code should have a different name than the main function.");
            }
            if (reuse_annotation == null) {
                JavaMethodsGenerator.printJavaNativeStub(env, writer, method, Mode.NORMAL, generate_error_checks, context_specific);
            }
            if (Utils.hasMethodBufferObjectParameter(method)) {
                JavaMethodsGenerator.printMethodWithMultiType(env, type_map, writer, interface_decl, method, TypeInfo.getDefaultTypeInfoMap(method), Mode.BUFFEROBJECT, generate_error_checks, context_specific);
                if (reuse_annotation == null) {
                    JavaMethodsGenerator.printJavaNativeStub(env, writer, method, Mode.BUFFEROBJECT, generate_error_checks, context_specific);
                }
            }
        }
    }

    private static void printJavaNativeStub(ProcessingEnvironment env, PrintWriter writer, ExecutableElement method, Mode mode, boolean generate_error_checks, boolean context_specific) {
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            writer.print("\tstatic native ");
        } else {
            Utils.printDocComment(writer, method, env);
            writer.print("\tpublic static native ");
        }
        writer.print(JavaMethodsGenerator.getResultType(method, true));
        writer.print(" " + Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(");
        boolean first_parameter = JavaMethodsGenerator.generateParametersJava(writer, method, TypeInfo.getDefaultTypeInfoMap(method), true, true, mode);
        if (context_specific) {
            if (!first_parameter) {
                writer.print(", ");
            }
            writer.print("long function_pointer");
        }
        writer.println(");");
    }

    private static boolean generateParametersJava(PrintWriter writer, ExecutableElement method, Map<VariableElement, TypeInfo> typeinfos_instance, boolean native_stub, boolean printTypes, Mode mode) {
        AutoSize auto_size_annotation;
        boolean first_parameter = true;
        for (VariableElement variableElement : method.getParameters()) {
            boolean hide_auto_parameter;
            Constant constant_annotation;
            if (native_stub && variableElement.getAnnotation(Helper.class) != null && !variableElement.getAnnotation(Helper.class).passToNative() || (constant_annotation = variableElement.getAnnotation(Constant.class)) != null && constant_annotation.isNative()) continue;
            AnnotationMirror auto_annotation_mirror = Utils.getParameterAutoAnnotation(variableElement);
            boolean bl = hide_auto_parameter = mode == Mode.NORMAL && !native_stub && auto_annotation_mirror != null;
            if (hide_auto_parameter) {
                VariableElement auto_parameter;
                TypeInfo auto_param_type_info;
                AutoType auto_type_annotation = variableElement.getAnnotation(AutoType.class);
                if (auto_type_annotation == null || (auto_param_type_info = typeinfos_instance.get(auto_parameter = Utils.findParameter(method, auto_type_annotation.value()))).getSignedness() != Signedness.BOTH) continue;
                if (!first_parameter) {
                    writer.print(", ");
                }
                first_parameter = false;
                if (printTypes) {
                    writer.print("boolean ");
                }
                writer.print("unsigned");
                continue;
            }
            if (variableElement.getAnnotation(Result.class) != null || !native_stub && (variableElement.getAnnotation(Constant.class) != null && !variableElement.getAnnotation(Constant.class).keepParam() || Utils.isReturnParameter(method, variableElement)) || mode == Mode.AUTOS && JavaMethodsGenerator.getAutoTypeParameter(method, variableElement) != null) continue;
            first_parameter = JavaMethodsGenerator.generateParameterJava(writer, variableElement, typeinfos_instance.get(variableElement), native_stub, printTypes, first_parameter, mode);
        }
        CachedResult cached_result_annotation = method.getAnnotation(CachedResult.class);
        TypeMirror typeMirror = Utils.getMethodReturnType(method);
        if (!((!native_stub || Utils.getNIOBufferType(typeMirror) == null) && !Utils.needResultSize(method) || (auto_size_annotation = method.getAnnotation(AutoSize.class)) != null && auto_size_annotation.isNative() || cached_result_annotation != null && cached_result_annotation.isRange())) {
            if (!first_parameter) {
                writer.print(", ");
            }
            first_parameter = false;
            if (printTypes) {
                writer.print("long ");
            }
            writer.print("result_size");
        }
        if (cached_result_annotation != null) {
            if (!first_parameter) {
                writer.print(", ");
            }
            if (mode == Mode.CACHEDRESULT) {
                if (printTypes) {
                    writer.print("long ");
                }
                writer.print("length, ");
            }
            first_parameter = false;
            if (printTypes) {
                writer.print(JavaMethodsGenerator.getResultType(method, native_stub));
            }
            writer.print(" old_buffer");
        }
        return first_parameter;
    }

    private static boolean generateParameterJava(PrintWriter writer, VariableElement param, TypeInfo type_info, boolean native_stub, boolean printTypes, boolean first_parameter, Mode mode) {
        BufferObject bo_annotation;
        Class<?> buffer_type = Utils.getNIOBufferType(param.asType());
        if (!first_parameter) {
            writer.print(", ");
        }
        if ((bo_annotation = param.getAnnotation(BufferObject.class)) != null && mode == Mode.BUFFEROBJECT) {
            if (buffer_type == null) {
                throw new RuntimeException("type of " + param + " is not a nio Buffer parameter but is annotated as buffer object");
            }
            if (printTypes) {
                writer.print("long ");
            }
            writer.print(param.getSimpleName() + "_buffer_offset");
        } else {
            if (native_stub && param.getAnnotation(PointerWrapper.class) != null) {
                writer.print("long ");
            } else {
                Class type = type_info.getType();
                if (native_stub && (type == CharSequence.class || type == CharSequence[].class || type == PointerBuffer.class || Buffer.class.isAssignableFrom(type))) {
                    writer.print("long ");
                } else if (printTypes) {
                    writer.print(type.getSimpleName() + " ");
                }
            }
            AutoSize auto_size_annotation = param.getAnnotation(AutoSize.class);
            if (auto_size_annotation != null) {
                writer.print(auto_size_annotation.value() + "_");
            }
            writer.print(param.getSimpleName());
        }
        return false;
    }

    private static void printBufferObjectCheck(PrintWriter writer, BufferKind kind, Mode mode, boolean context_specific) {
        String bo_check_method_name = kind.toString();
        writer.print("\t\tGLChecks.ensure" + bo_check_method_name);
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("enabled");
        } else {
            writer.print("disabled");
        }
        if (context_specific) {
            writer.println("(caps);");
        } else {
            writer.println("();");
        }
    }

    private static void printBufferObjectChecks(PrintWriter writer, ExecutableElement method, Mode mode, boolean context_specific) {
        EnumSet<BufferKind> check_set = EnumSet.noneOf(BufferKind.class);
        for (VariableElement variableElement : method.getParameters()) {
            BufferObject bo_annotation = variableElement.getAnnotation(BufferObject.class);
            if (bo_annotation == null) continue;
            check_set.add(bo_annotation.value());
        }
        for (BufferKind bufferKind : check_set) {
            JavaMethodsGenerator.printBufferObjectCheck(writer, bufferKind, mode, context_specific);
        }
    }

    private static void printMethodWithMultiType(ProcessingEnvironment env, TypeMap type_map, PrintWriter writer, TypeElement interface_decl, ExecutableElement method, Map<VariableElement, TypeInfo> typeinfos_instance, Mode mode, boolean generate_error_checks, boolean context_specific) {
        String tabs;
        Code code_annotation;
        String method_name;
        Utils.printDocComment(writer, method, env);
        if (method.getAnnotation(Deprecated.class) != null) {
            writer.println("\t@Deprecated");
        }
        if (interface_decl.getAnnotation(Private.class) == null && method.getAnnotation(Private.class) == null) {
            writer.print("\tpublic static ");
        } else {
            writer.print("\tstatic ");
        }
        writer.print(JavaMethodsGenerator.getResultType(method, false));
        StripPostfix strip_annotation = method.getAnnotation(StripPostfix.class);
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        String string = method_name = alt_annotation == null || alt_annotation.javaAlt() ? method.getSimpleName().toString() : alt_annotation.value();
        if (strip_annotation != null && mode == Mode.NORMAL) {
            method_name = JavaMethodsGenerator.getPostfixStrippedName(type_map, interface_decl, method);
        }
        writer.print(" " + method_name + "(");
        JavaMethodsGenerator.generateParametersJava(writer, method, typeinfos_instance, false, true, mode);
        writer.println(") {");
        TypeMirror result_type = Utils.getMethodReturnType(method);
        boolean has_result = !result_type.equals(env.getTypeUtils().getNoType(TypeKind.VOID));
        Reuse reuse_annotation = method.getAnnotation(Reuse.class);
        if (reuse_annotation != null) {
            writer.print("\t\t");
            if (has_result || method.getAnnotation(GLreturn.class) != null) {
                writer.print("return ");
            }
            writer.print(reuse_annotation.value() + "." + (reuse_annotation.method().length() > 0 ? reuse_annotation.method() : method_name) + "(");
            JavaMethodsGenerator.generateParametersJava(writer, method, typeinfos_instance, false, false, mode);
            writer.println(");\n\t}");
            return;
        }
        if (context_specific) {
            type_map.printCapabilitiesInit(writer);
            writer.print("\t\tlong function_pointer = " + type_map.getCapabilities() + ".");
            writer.println(Utils.getFunctionAddressName(interface_decl, method, true) + ";");
            writer.print("\t\tBufferChecks.checkFunctionAddress(");
            writer.println("function_pointer);");
        }
        if ((code_annotation = method.getAnnotation(Code.class)) != null && code_annotation.value().length() > 0) {
            writer.println(code_annotation.value());
        }
        JavaMethodsGenerator.printBufferObjectChecks(writer, method, mode, context_specific);
        JavaMethodsGenerator.printParameterChecks(writer, method, typeinfos_instance, mode, generate_error_checks);
        JavaMethodsGenerator.printParameterCaching(writer, interface_decl, method, mode, context_specific);
        if (code_annotation != null && code_annotation.javaBeforeNative().length() > 0) {
            writer.println(code_annotation.javaBeforeNative());
        }
        writer.print("\t\t");
        PointerWrapper pointer_wrapper_annotation = method.getAnnotation(PointerWrapper.class);
        if (has_result) {
            writer.print(JavaMethodsGenerator.getResultType(method, false) + " " + "__result");
            if (code_annotation != null && code_annotation.tryBlock()) {
                writer.print(" = " + JavaMethodsGenerator.getDefaultResultValue(method));
                writer.println(";\n\t\ttry {");
                writer.print("\t\t\t__result");
            }
            writer.print(" = ");
            if (pointer_wrapper_annotation != null) {
                if (pointer_wrapper_annotation.factory().length() > 0) {
                    writer.print(pointer_wrapper_annotation.factory() + "(");
                } else {
                    writer.print("new " + JavaMethodsGenerator.getResultType(method, false) + "(");
                }
            }
        } else if (method.getAnnotation(GLreturn.class) != null) {
            has_result = true;
            Utils.printGLReturnPre(writer, method, method.getAnnotation(GLreturn.class), type_map);
        }
        writer.print(Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(");
        boolean first_parameter = JavaMethodsGenerator.printMethodCallArguments(writer, method, typeinfos_instance, mode, type_map);
        if (context_specific) {
            if (!first_parameter) {
                writer.print(", ");
            }
            writer.print("function_pointer");
        }
        if (has_result && pointer_wrapper_annotation != null) {
            writer.print(")");
            if (pointer_wrapper_annotation.params().length() > 0) {
                writer.print(", " + pointer_wrapper_annotation.params());
            }
        }
        writer.println(");");
        if (code_annotation != null && code_annotation.javaAfterNative().length() > 0) {
            writer.println(code_annotation.javaAfterNative());
        }
        String string2 = tabs = code_annotation != null && code_annotation.tryBlock() ? "\t\t\t" : "\t\t";
        if (generate_error_checks && method.getAnnotation(NoErrorCheck.class) == null) {
            type_map.printErrorCheckMethod(writer, method, tabs);
        }
        if (has_result) {
            if (method.getAnnotation(GLreturn.class) == null) {
                if (ByteBuffer.class.equals((Object)Utils.getJavaType(result_type))) {
                    writer.println(tabs + "return LWJGLUtil.CHECKS && " + "__result" + " == null ? null : " + "__result" + ".order(ByteOrder.nativeOrder());");
                } else {
                    writer.println(tabs + "return " + "__result" + ";");
                }
            } else {
                Utils.printGLReturnPost(writer, method, method.getAnnotation(GLreturn.class), type_map);
            }
        }
        if (code_annotation != null && code_annotation.tryBlock()) {
            writer.println("\t\t} finally {");
            writer.println(code_annotation.javaFinally());
            writer.println("\t\t}");
        }
        writer.println("\t}");
    }

    private static String getExtensionPostfix(TypeElement interface_decl) {
        String interface_simple_name = interface_decl.getSimpleName().toString();
        Extension extension_annotation = interface_decl.getAnnotation(Extension.class);
        if (extension_annotation == null) {
            int underscore_index = interface_simple_name.indexOf("_");
            if (underscore_index != -1) {
                return interface_simple_name.substring(0, underscore_index);
            }
            return "";
        }
        return extension_annotation.postfix();
    }

    private static VariableElement getAutoTypeParameter(ExecutableElement method, VariableElement target_parameter) {
        for (VariableElement variableElement : method.getParameters()) {
            String parameter_name;
            AnnotationMirror auto_annotation = Utils.getParameterAutoAnnotation(variableElement);
            if (auto_annotation == null) continue;
            Class<? extends Annotation> annotation_type = NativeTypeTranslator.getClassFromType(auto_annotation.getAnnotationType());
            if (annotation_type.equals(AutoType.class)) {
                parameter_name = variableElement.getAnnotation(AutoType.class).value();
            } else if (annotation_type.equals(AutoSize.class)) {
                parameter_name = variableElement.getAnnotation(AutoSize.class).value();
            } else {
                throw new RuntimeException("Unknown annotation type " + annotation_type);
            }
            if (!target_parameter.getSimpleName().toString().equals(parameter_name)) continue;
            return variableElement;
        }
        return null;
    }

    private static boolean hasAnyParameterAutoTypeAnnotation(ExecutableElement method, VariableElement target_param) {
        for (VariableElement variableElement : method.getParameters()) {
            VariableElement type_target_param;
            AutoType auto_type_annotation = variableElement.getAnnotation(AutoType.class);
            if (auto_type_annotation == null || !target_param.equals(type_target_param = Utils.findParameter(method, auto_type_annotation.value()))) continue;
            return true;
        }
        return false;
    }

    private static Pattern getPostfixPattern(String regex) {
        Pattern pattern = postfixPatterns.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            postfixPatterns.put(regex, pattern);
        }
        return pattern;
    }

    private static String getPostfixStrippedName(TypeMap type_map, TypeElement interface_decl, ExecutableElement method) {
        boolean postfixOverride;
        StripPostfix strip_annotation = method.getAnnotation(StripPostfix.class);
        VariableElement postfix_parameter = Utils.findParameter(method, strip_annotation.value());
        String postfix = strip_annotation.postfix();
        boolean bl = postfixOverride = !"NULL".equals(postfix) || !strip_annotation.hasPostfix();
        if (!postfixOverride) {
            PostfixTranslator translator = new PostfixTranslator(type_map, postfix_parameter);
            postfix_parameter.asType().accept(translator, null);
            postfix = translator.getSignature();
        } else if (!strip_annotation.hasPostfix()) {
            postfix = "";
        }
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        String method_name = alt_annotation == null || alt_annotation.javaAlt() ? method.getSimpleName().toString() : alt_annotation.value();
        String extension_postfix = "NULL".equals(strip_annotation.extension()) ? JavaMethodsGenerator.getExtensionPostfix(interface_decl) : strip_annotation.extension();
        Matcher matcher = JavaMethodsGenerator.getPostfixPattern(postfixOverride ? postfix + "(?:v)?" + extension_postfix + "$" : "(?:" + postfix + "(?:v)?|i(?:64)?_v|v)" + extension_postfix + "$").matcher(method_name);
        if (!matcher.find()) {
            throw new RuntimeException(method_name + " is specified as being postfix stripped on parameter " + postfix_parameter + ", but it's postfix is neither '" + postfix + "' nor 'v'");
        }
        return method_name.substring(0, matcher.start()) + extension_postfix;
    }

    private static int getBufferElementSizeExponent(Class c) {
        if (IntBuffer.class.equals((Object)c)) {
            return 2;
        }
        if (LongBuffer.class.equals((Object)c)) {
            return 3;
        }
        if (DoubleBuffer.class.equals((Object)c)) {
            return 3;
        }
        if (ShortBuffer.class.equals((Object)c)) {
            return 1;
        }
        if (ByteBuffer.class.equals((Object)c)) {
            return 0;
        }
        if (FloatBuffer.class.equals((Object)c)) {
            return 2;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean printMethodCallArgument(PrintWriter writer, ExecutableElement method, VariableElement param, Map<VariableElement, TypeInfo> typeinfos_instance, Mode mode, boolean first_parameter, TypeMap type_map) {
        if (!first_parameter) {
            writer.print(", ");
        }
        AnnotationMirror auto_annotation = Utils.getParameterAutoAnnotation(param);
        Constant constant_annotation = param.getAnnotation(Constant.class);
        if (constant_annotation != null) {
            writer.print(constant_annotation.value());
            return false;
        } else if (auto_annotation != null && mode == Mode.NORMAL) {
            Class<? extends Annotation> param_type = NativeTypeTranslator.getClassFromType(auto_annotation.getAnnotationType());
            if (AutoType.class.equals(param_type)) {
                AutoType auto_type_annotation = param.getAnnotation(AutoType.class);
                VariableElement auto_parameter = Utils.findParameter(method, auto_type_annotation.value());
                String auto_type = typeinfos_instance.get(auto_parameter).getAutoType();
                if (auto_type == null) {
                    throw new RuntimeException("No auto type for parameter " + param.getSimpleName() + " in method " + method);
                }
                writer.print(auto_type);
                return false;
            } else {
                if (!AutoSize.class.equals(param_type)) throw new RuntimeException("Unknown auto annotation " + param_type);
                AutoSize auto_size_annotation = param.getAnnotation(AutoSize.class);
                if (!auto_size_annotation.useExpression()) {
                    String auto_parameter_name = auto_size_annotation.value();
                    VariableElement auto_target_param = Utils.findParameter(method, auto_parameter_name);
                    TypeInfo auto_target_type_info = typeinfos_instance.get(auto_target_param);
                    boolean shift_remaining = !JavaMethodsGenerator.hasAnyParameterAutoTypeAnnotation(method, auto_target_param) && Utils.isParameterMultiTyped(auto_target_param);
                    int shifting = 0;
                    if (shift_remaining && (shifting = JavaMethodsGenerator.getBufferElementSizeExponent(auto_target_type_info.getType())) > 0) {
                        writer.print("(");
                    }
                    if (auto_size_annotation.canBeNull()) {
                        writer.print("(" + auto_parameter_name + " == null ? 0 : " + auto_parameter_name + ".remaining())");
                    } else {
                        writer.print(auto_parameter_name + ".remaining()");
                    }
                    if (shift_remaining && shifting > 0) {
                        writer.print(" << " + shifting);
                        writer.print(")");
                    }
                }
                writer.print(auto_size_annotation.expression());
            }
            return false;
        } else if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
            writer.print(param.getSimpleName() + "_buffer_offset");
            return false;
        } else {
            PointerWrapper pointer_annotation;
            boolean hide_buffer;
            Class type = typeinfos_instance.get(param).getType();
            Check check_annotation = param.getAnnotation(Check.class);
            boolean bl = hide_buffer = mode == Mode.AUTOS && JavaMethodsGenerator.getAutoTypeParameter(method, param) != null;
            if (hide_buffer) {
                writer.print("0L");
            } else if (type == CharSequence.class || type == CharSequence[].class) {
                String offset = Utils.getStringOffset(method, param);
                writer.print("APIUtil.getBuffer");
                if (param.getAnnotation(NullTerminated.class) != null) {
                    writer.print("NT");
                }
                writer.print('(');
                writer.print(type_map.getAPIUtilParam(true));
                writer.print(param.getSimpleName());
                if (offset != null) {
                    writer.print(", " + offset);
                }
                writer.print(")");
            } else {
                Class<?> buffer_type;
                AutoSize auto_size_annotation = param.getAnnotation(AutoSize.class);
                if (auto_size_annotation != null) {
                    writer.print(auto_size_annotation.value() + "_");
                }
                if ((buffer_type = Utils.getNIOBufferType(param.asType())) == null) {
                    writer.print(param.getSimpleName());
                } else {
                    writer.print("MemoryUtil.getAddress");
                    if (check_annotation != null && check_annotation.canBeNull()) {
                        writer.print("Safe");
                    }
                    writer.print("(");
                    writer.print(param.getSimpleName());
                    writer.print(")");
                }
            }
            if (type == Long.TYPE || (pointer_annotation = param.getAnnotation(PointerWrapper.class)) == null) return false;
            if (pointer_annotation.canBeNull()) {
                writer.print(" == null ? 0 : " + param.getSimpleName());
            }
            writer.print(".getPointer()");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean printMethodCallArguments(PrintWriter writer, ExecutableElement method, Map<VariableElement, TypeInfo> typeinfos_instance, Mode mode, TypeMap type_map) {
        boolean first_parameter = true;
        for (VariableElement variableElement : method.getParameters()) {
            Constant constant_annotation;
            if (variableElement.getAnnotation(Result.class) != null || variableElement.getAnnotation(Helper.class) != null && !variableElement.getAnnotation(Helper.class).passToNative() || (constant_annotation = variableElement.getAnnotation(Constant.class)) != null && constant_annotation.isNative()) continue;
            first_parameter = JavaMethodsGenerator.printMethodCallArgument(writer, method, variableElement, typeinfos_instance, mode, first_parameter, type_map);
        }
        if (Utils.getNIOBufferType(Utils.getMethodReturnType(method)) != null) {
            if (method.getAnnotation(CachedResult.class) != null && method.getAnnotation(CachedResult.class).isRange()) {
                first_parameter = false;
                Utils.printExtraCallArguments(writer, method, "");
            } else {
                AutoSize auto_size_annotation = method.getAnnotation(AutoSize.class);
                if (auto_size_annotation == null || !auto_size_annotation.isNative()) {
                    void var7_11;
                    if (!first_parameter) {
                        writer.print(", ");
                    }
                    first_parameter = false;
                    if (mode == Mode.CACHEDRESULT) {
                        String string = "length";
                    } else if (auto_size_annotation == null) {
                        String string = "result_size";
                    } else {
                        String string = auto_size_annotation.value();
                    }
                    Utils.printExtraCallArguments(writer, method, (String)var7_11);
                }
            }
        }
        return first_parameter;
    }

    private static void printParameterCaching(PrintWriter writer, TypeElement interface_decl, ExecutableElement method, Mode mode, boolean context_specific) {
        for (VariableElement variableElement : method.getParameters()) {
            Class java_type = Utils.getJavaType(variableElement.asType());
            CachedReference cachedReference = variableElement.getAnnotation(CachedReference.class);
            if (!Buffer.class.isAssignableFrom(java_type) || cachedReference == null || mode == Mode.BUFFEROBJECT && variableElement.getAnnotation(BufferObject.class) != null || variableElement.getAnnotation(Result.class) != null) continue;
            writer.print("\t\tif ( LWJGLUtil.CHECKS ) StateTracker.");
            if (context_specific) {
                writer.print("getReferences(caps).");
            } else {
                writer.print("getTracker().");
            }
            if (cachedReference.name().length() > 0) {
                writer.print(cachedReference.name());
            } else {
                writer.print(Utils.getReferenceName(interface_decl, method, variableElement));
            }
            if (cachedReference.index().length() > 0) {
                writer.print("[" + cachedReference.index() + "]");
            }
            writer.println(" = " + variableElement.getSimpleName() + ";");
        }
    }

    private static void printParameterChecks(PrintWriter writer, ExecutableElement method, Map<VariableElement, TypeInfo> typeinfos, Mode mode, boolean generate_error_checks) {
        GenerateAutos gen_autos_annotation;
        if (mode == Mode.NORMAL && (gen_autos_annotation = method.getAnnotation(GenerateAutos.class)) != null && gen_autos_annotation.sizeVariables().length > 0) {
            for (VariableElement variableElement : method.getParameters()) {
                if (Arrays.binarySearch(gen_autos_annotation.sizeVariables(), variableElement.getSimpleName().toString()) < 0) continue;
                int shifting = JavaMethodsGenerator.getBufferElementSizeExponent(typeinfos.get(variableElement).getType());
                Check check_annotation = variableElement.getAnnotation(Check.class);
                writer.print("\t\tlong " + variableElement.getSimpleName() + "_size = ");
                if (check_annotation == null || !check_annotation.canBeNull()) {
                    writer.println(variableElement.getSimpleName() + ".remaining() << " + shifting + ";");
                    continue;
                }
                writer.println(variableElement.getSimpleName() + " == null ? 0 : " + variableElement.getSimpleName() + ".remaining() << " + shifting + ";");
            }
        }
        for (VariableElement variableElement : method.getParameters()) {
            Class clazz = Utils.getJavaType(variableElement.asType());
            if (!clazz.isArray() && (!Utils.isAddressableType(clazz) || mode == Mode.BUFFEROBJECT && variableElement.getAnnotation(BufferObject.class) != null || mode == Mode.AUTOS && JavaMethodsGenerator.getAutoTypeParameter(method, variableElement) != null || variableElement.getAnnotation(Result.class) != null || Utils.isReturnParameter(method, variableElement))) continue;
            String check_value = null;
            boolean can_be_null = false;
            Check check_annotation = variableElement.getAnnotation(Check.class);
            if (check_annotation != null) {
                check_value = check_annotation.value();
                can_be_null = check_annotation.canBeNull();
            }
            if ((Buffer.class.isAssignableFrom(clazz) || PointerBuffer.class.isAssignableFrom(clazz)) && variableElement.getAnnotation(Constant.class) == null) {
                TypeInfo typeinfo = typeinfos.get(variableElement);
                JavaMethodsGenerator.printParameterCheck(writer, method, variableElement.getSimpleName().toString(), typeinfo.getType().getSimpleName(), check_value, can_be_null, variableElement.getAnnotation(NullTerminated.class), generate_error_checks);
                continue;
            }
            if (String.class.equals((Object)clazz)) {
                if (can_be_null) continue;
                writer.println("\t\tBufferChecks.checkNotNull(" + variableElement.getSimpleName() + ");");
                continue;
            }
            if (!clazz.isArray()) continue;
            JavaMethodsGenerator.printArrayParameterCheck(writer, variableElement.getSimpleName().toString(), check_value, can_be_null);
        }
        if (method.getAnnotation(CachedResult.class) != null) {
            JavaMethodsGenerator.printParameterCheck(writer, method, "old_buffer", null, null, true, null, generate_error_checks);
        }
    }

    private static void printParameterCheck(PrintWriter writer, ExecutableElement method, String name, String type, String check_value, boolean can_be_null, NullTerminated null_terminated, boolean generate_error_checks) {
        Check check_annotation;
        String tabs;
        if (can_be_null) {
            writer.print("\t\tif (" + name + " != null)");
            if (null_terminated != null) {
                writer.println(" {");
            } else {
                writer.println();
            }
            tabs = "\t\t\t";
        } else {
            tabs = "\t\t";
        }
        writer.print(tabs + "BufferChecks.check");
        if (check_value != null && check_value.length() > 0) {
            writer.print("Buffer");
            if ("Buffer".equals(type)) {
                writer.print("Size");
            }
            writer.print("(" + name + ", " + check_value);
        } else {
            writer.print("Direct(" + name);
        }
        writer.println(");");
        if (can_be_null && generate_error_checks && (check_annotation = method.getAnnotation(Check.class)) != null && check_annotation.value().equals(name)) {
            writer.println("\t\telse");
            writer.println("\t\t\t" + name + " = APIUtil.getBufferIntDebug();");
        }
        if (null_terminated != null) {
            writer.print(tabs + "BufferChecks.checkNullTerminated(");
            writer.print(name);
            if (null_terminated.value().length() > 0) {
                writer.print(", ");
                writer.print(null_terminated.value());
            }
            writer.println(");");
            if (can_be_null) {
                writer.println("\t\t}");
            }
        }
    }

    private static void printArrayParameterCheck(PrintWriter writer, String name, String check_value, boolean can_be_null) {
        String tabs;
        if (can_be_null) {
            writer.println("\t\tif (" + name + " != null)");
            tabs = "\t\t\t";
        } else {
            tabs = "\t\t";
        }
        writer.print(tabs + "BufferChecks.checkArray(" + name);
        if (check_value != null && check_value.length() > 0) {
            writer.print(", " + check_value);
        }
        writer.println(");");
    }

    private static String getResultType(ExecutableElement method, boolean native_stub) {
        if (native_stub && method.getAnnotation(PointerWrapper.class) != null) {
            return "long";
        }
        if (!native_stub && method.getAnnotation(GLreturn.class) != null) {
            return Utils.getMethodReturnType(method, method.getAnnotation(GLreturn.class), false);
        }
        return Utils.getJavaType(Utils.getMethodReturnType(method)).getSimpleName();
    }

    private static String getDefaultResultValue(ExecutableElement method) {
        if (method.getAnnotation(GLreturn.class) != null) {
            String type = Utils.getMethodReturnType(method, method.getAnnotation(GLreturn.class), false);
            if ("boolean".equals(type)) {
                return "false";
            }
            if (Character.isLowerCase(type.charAt(0))) {
                return "0";
            }
            return "null";
        }
        Class type = Utils.getJavaType(Utils.getMethodReturnType(method));
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return "false";
            }
            return "0";
        }
        return "null";
    }
}

