/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapper;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.Auto;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Extension;
import org.lwjgl.util.generator.JavaTypeTranslator;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.OutParameter;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.opengl.GLboolean;
import org.lwjgl.util.generator.opengl.GLchar;
import org.lwjgl.util.generator.opengl.GLcharARB;
import org.lwjgl.util.generator.opengl.GLreturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TYPEDEF_POSTFIX = "PROC";
    public static final String FUNCTION_POINTER_VAR_NAME = "function_pointer";
    public static final String FUNCTION_POINTER_POSTFIX = "_pointer";
    public static final String CHECKS_CLASS_NAME = "GLChecks";
    public static final String CONTEXT_CAPS_CLASS_NAME = "ContextCapabilities";
    public static final String STUB_INITIALIZER_NAME = "initNativeStubs";
    public static final String BUFFER_OBJECT_METHOD_POSTFIX = "BO";
    public static final String BUFFER_OBJECT_PARAMETER_POSTFIX = "_buffer_offset";
    public static final String RESULT_SIZE_NAME = "result_size";
    public static final String RESULT_VAR_NAME = "__result";
    public static final String CACHED_BUFFER_LENGTH_NAME = "length";
    public static final String CACHED_BUFFER_NAME = "old_buffer";
    private static final String OVERLOADED_METHOD_PREFIX = "n";
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    public static String getTypedefName(ExecutableElement method) {
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        return (alt_annotation == null ? method.getSimpleName() : alt_annotation.value()) + TYPEDEF_POSTFIX;
    }

    public static String getFunctionAddressName(TypeElement interface_decl, ExecutableElement method) {
        return Utils.getFunctionAddressName(interface_decl, method, false);
    }

    public static String getFunctionAddressName(TypeElement interface_decl, ExecutableElement method, boolean forceAlt) {
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        if (alt_annotation == null || alt_annotation.nativeAlt() && !forceAlt) {
            return method.getSimpleName().toString();
        }
        return alt_annotation.value();
    }

    public static boolean isFinal(Element d) {
        Extension extension_annotation = d.getAnnotation(Extension.class);
        return extension_annotation == null || extension_annotation.isFinal();
    }

    public static List<AnnotationMirror> getSortedAnnotations(List<? extends AnnotationMirror> annotations) {
        ArrayList<AnnotationMirror> annotation_list = new ArrayList<AnnotationMirror>(annotations);
        Collections.sort(annotation_list, new AnnotationMirrorComparator());
        return annotation_list;
    }

    public static String getReferenceName(TypeElement interface_decl, ExecutableElement method, VariableElement param) {
        return interface_decl.getSimpleName() + "_" + method.getSimpleName() + "_" + param.getSimpleName();
    }

    public static boolean isAddressableType(TypeMirror type) {
        return Utils.isAddressableType(Utils.getJavaType(type));
    }

    public static boolean isAddressableType(Class type) {
        if (type.isArray()) {
            Class<?> component_type = type.getComponentType();
            return Utils.isAddressableTypeImpl(component_type) || PointerWrapper.class.isAssignableFrom(component_type);
        }
        return Utils.isAddressableTypeImpl(type);
    }

    private static boolean isAddressableTypeImpl(Class type) {
        return Buffer.class.isAssignableFrom(type) || PointerBuffer.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type);
    }

    public static Class getJavaType(TypeMirror type_mirror) {
        JavaTypeTranslator translator = new JavaTypeTranslator();
        type_mirror.accept(translator, null);
        return translator.getType();
    }

    private static boolean hasParameterMultipleTypes(VariableElement param) {
        int num_native_annotations = 0;
        for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
            if (NativeTypeTranslator.getAnnotation(annotationMirror, NativeType.class) == null) continue;
            ++num_native_annotations;
        }
        return num_native_annotations > 1;
    }

    public static boolean isParameterMultiTyped(VariableElement param) {
        boolean result = Buffer.class.equals((Object)Utils.getJavaType(param.asType()));
        if (!result && Utils.hasParameterMultipleTypes(param)) {
            throw new RuntimeException(param + " not defined as java.nio.Buffer but has multiple types");
        }
        return result;
    }

    public static VariableElement findParameter(ExecutableElement method, String name) {
        for (VariableElement variableElement : method.getParameters()) {
            if (!variableElement.getSimpleName().toString().equals(name)) continue;
            return variableElement;
        }
        throw new RuntimeException("Parameter " + name + " not found");
    }

    public static void printDocComment(PrintWriter writer, Element decl, ProcessingEnvironment pe) {
        String overloadsComment = decl instanceof ExecutableElement && decl.getAnnotation(Alternate.class) != null ? "Overloads " + decl.getAnnotation(Alternate.class).value() + "." : null;
        String doc_comment = pe.getElementUtils().getDocComment(decl);
        if (doc_comment != null) {
            String tab = decl instanceof TypeElement ? "" : "\t";
            writer.println(tab + "/**");
            if (overloadsComment != null) {
                writer.println("\t * " + overloadsComment);
                writer.println("\t * <p>");
            }
            StringTokenizer doc_lines = new StringTokenizer(doc_comment, "\n", true);
            boolean lastWasNL = false;
            while (doc_lines.hasMoreTokens()) {
                String t = doc_lines.nextToken();
                if ("\n".equals(t)) {
                    if (lastWasNL) {
                        writer.println(tab + " * <p>");
                    }
                    lastWasNL = true;
                    continue;
                }
                writer.println(tab + " * " + t);
                lastWasNL = false;
            }
            writer.println(tab + " */");
        } else if (overloadsComment != null) {
            writer.println("\t/** " + overloadsComment + " */");
        }
    }

    public static AnnotationMirror getParameterAutoAnnotation(VariableElement param) {
        for (AnnotationMirror annotationMirror : param.getAnnotationMirrors()) {
            if (NativeTypeTranslator.getAnnotation(annotationMirror, Auto.class) == null) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isMethodIndirect(boolean generate_error_checks, boolean context_specific, ExecutableElement method) {
        return true;
    }

    public static String getNativeQualifiedName(String qualified_name) {
        return DOT_PATTERN.matcher(qualified_name).replaceAll("_");
    }

    public static String getQualifiedNativeMethodName(String qualified_class_name, String method_name) {
        if (method_name.indexOf(95) != -1) {
            method_name = method_name.replace("_", "_1");
        }
        return "Java_" + Utils.getNativeQualifiedName(qualified_class_name) + "_" + method_name;
    }

    public static String getQualifiedNativeMethodName(String qualified_class_name, ExecutableElement method, boolean generate_error_checks, boolean context_specific) {
        String method_name = Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific);
        return Utils.getQualifiedNativeMethodName(qualified_class_name, method_name);
    }

    public static VariableElement getResultParameter(ExecutableElement method) {
        VariableElement result_param = null;
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.getAnnotation(Result.class) == null) continue;
            if (result_param != null) {
                throw new RuntimeException("Multiple parameters annotated with Result in method " + method);
            }
            result_param = variableElement;
        }
        return result_param;
    }

    public static TypeMirror getMethodReturnType(ExecutableElement method) {
        VariableElement result_param = Utils.getResultParameter(method);
        TypeMirror result_type = result_param != null ? result_param.asType() : method.getReturnType();
        return result_type;
    }

    public static String getMethodReturnType(ExecutableElement method, GLreturn return_annotation, boolean buffer) {
        VariableElement return_param = null;
        for (VariableElement variableElement : method.getParameters()) {
            if (!variableElement.getSimpleName().toString().equals(return_annotation.value())) continue;
            return_param = variableElement;
            break;
        }
        if (return_param == null) {
            throw new RuntimeException("The @GLreturn parameter \"" + return_annotation.value() + "\" could not be found in method: " + method);
        }
        TypeKind kind = NativeTypeTranslator.getPrimitiveKindFromBufferClass(Utils.getJavaType(return_param.asType()));
        if (return_param.getAnnotation(GLboolean.class) != null) {
            kind = TypeKind.BOOLEAN;
        }
        if (kind == TypeKind.BYTE && (return_param.getAnnotation(GLchar.class) != null || return_param.getAnnotation(GLcharARB.class) != null)) {
            return "String";
        }
        String string = JavaTypeTranslator.getPrimitiveClassFromKind(kind).getName();
        return buffer ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string;
    }

    public static boolean needResultSize(ExecutableElement method) {
        return Utils.getNIOBufferType(Utils.getMethodReturnType(method)) != null && method.getAnnotation(AutoSize.class) == null;
    }

    public static void printExtraCallArguments(PrintWriter writer, ExecutableElement method, String size_parameter_name) {
        writer.print(size_parameter_name);
        if (method.getAnnotation(CachedResult.class) != null) {
            writer.print(", old_buffer");
        }
    }

    private static String getClassName(TypeElement interface_decl, String opengl_name) {
        Extension extension_annotation = interface_decl.getAnnotation(Extension.class);
        if (extension_annotation != null && !"".equals(extension_annotation.className())) {
            return extension_annotation.className();
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < opengl_name.length(); ++i) {
            int ch = opengl_name.codePointAt(i);
            if (ch == 95) {
                result.appendCodePoint(Character.toUpperCase(opengl_name.codePointAt(++i)));
                continue;
            }
            result.appendCodePoint(ch);
        }
        return result.toString();
    }

    public static boolean hasMethodBufferObjectParameter(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.getAnnotation(BufferObject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static String getQualifiedClassName(TypeElement interface_decl) {
        return interface_decl.getEnclosingElement().asType().toString() + "." + Utils.getSimpleClassName(interface_decl);
    }

    public static String getSimpleClassName(TypeElement interface_decl) {
        return Utils.getClassName(interface_decl, interface_decl.getSimpleName().toString());
    }

    public static Class<?> getNIOBufferType(TypeMirror t) {
        Class param_type = Utils.getJavaType(t);
        if (Buffer.class.isAssignableFrom(param_type)) {
            return param_type;
        }
        if (param_type == CharSequence.class || param_type == CharSequence[].class || param_type == PointerBuffer.class) {
            return ByteBuffer.class;
        }
        return null;
    }

    public static String getSimpleNativeMethodName(ExecutableElement method, boolean generate_error_checks, boolean context_specific) {
        String method_name;
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        String string = method_name = alt_annotation == null || alt_annotation.nativeAlt() ? method.getSimpleName().toString() : alt_annotation.value();
        if (Utils.isMethodIndirect(generate_error_checks, context_specific, method)) {
            method_name = OVERLOADED_METHOD_PREFIX + method_name;
        }
        return method_name;
    }

    static boolean isReturnParameter(ExecutableElement method, VariableElement param) {
        GLreturn string_annotation = method.getAnnotation(GLreturn.class);
        if (string_annotation == null || !string_annotation.value().equals(param.getSimpleName().toString())) {
            return false;
        }
        if (param.getAnnotation(OutParameter.class) == null) {
            throw new RuntimeException("The parameter specified in @GLreturn is not annotated with @OutParameter in method: " + method);
        }
        if (param.getAnnotation(Check.class) != null) {
            throw new RuntimeException("The parameter specified in @GLreturn is annotated with @Check in method: " + method);
        }
        if (param.getAnnotation(GLchar.class) != null && Utils.getJavaType(param.asType()).equals(ByteBuffer.class) && string_annotation.maxLength().length() == 0) {
            throw new RuntimeException("The @GLreturn annotation is missing a maxLength parameter in method: " + method);
        }
        return true;
    }

    static String getStringOffset(ExecutableElement method, VariableElement param) {
        String offset = null;
        for (VariableElement variableElement : method.getParameters()) {
            if (param != null && variableElement.getSimpleName().equals(param.getSimpleName())) break;
            if (variableElement.getAnnotation(NullTerminated.class) != null) continue;
            Class type = Utils.getJavaType(variableElement.asType());
            if (type.equals(CharSequence.class)) {
                if (offset == null) {
                    offset = variableElement.getSimpleName() + ".length()";
                    continue;
                }
                offset = offset + " + " + variableElement.getSimpleName() + ".length()";
                continue;
            }
            if (!type.equals(CharSequence[].class)) continue;
            if (offset == null) {
                offset = "APIUtil.getTotalLength(" + variableElement.getSimpleName() + ")";
                continue;
            }
            offset = offset + " + APIUtil.getTotalLength(" + variableElement.getSimpleName() + ")";
        }
        return offset;
    }

    static void printGLReturnPre(PrintWriter writer, ExecutableElement method, GLreturn return_annotation, TypeMap type_map) {
        String return_type = Utils.getMethodReturnType(method, return_annotation, true);
        if ("String".equals(return_type)) {
            if (!return_annotation.forceMaxLength()) {
                writer.println("IntBuffer " + return_annotation.value() + "_length = APIUtil.getLengths(" + type_map.getAPIUtilParam(false) + ");");
                writer.print("\t\t");
            }
            writer.print("ByteBuffer " + return_annotation.value() + " = APIUtil.getBufferByte(" + type_map.getAPIUtilParam(true) + return_annotation.maxLength());
            String offset = Utils.getStringOffset(method, null);
            if (offset != null) {
                writer.print(" + " + offset);
            }
            writer.println(");");
        } else {
            String buffer_type = "Boolean".equals(return_type) ? "Byte" : return_type;
            writer.print(buffer_type + "Buffer " + return_annotation.value() + " = APIUtil.getBuffer" + buffer_type + "(" + type_map.getAPIUtilParam(false));
            if ("Byte".equals(buffer_type)) {
                writer.print((type_map.getAPIUtilParam(false).length() > 0 ? ", " : "") + "1");
            }
            writer.println(");");
        }
        Code code_annotation = method.getAnnotation(Code.class);
        if (code_annotation != null && code_annotation.tryBlock()) {
            writer.println("\t\ttry {");
            writer.print("\t\t\t");
        } else {
            writer.print("\t\t");
        }
    }

    static void printGLReturnPost(PrintWriter writer, ExecutableElement method, GLreturn return_annotation, TypeMap type_map) {
        String return_type = Utils.getMethodReturnType(method, return_annotation, true);
        if ("String".equals(return_type)) {
            writer.print("\t\t" + return_annotation.value() + ".limit(");
            String offset = Utils.getStringOffset(method, null);
            if (offset != null) {
                writer.print(offset + " + ");
            }
            if (return_annotation.forceMaxLength()) {
                writer.print(return_annotation.maxLength());
            } else {
                writer.print(return_annotation.value() + "_length.get(0)");
            }
            writer.println(");");
            writer.println("\t\treturn APIUtil.getString(" + type_map.getAPIUtilParam(true) + return_annotation.value() + ");");
        } else {
            writer.print("\t\treturn " + return_annotation.value() + ".get(0)");
            if ("Boolean".equals(return_type)) {
                writer.print(" == 1");
            }
            writer.println(";");
        }
    }

    public static Collection<VariableElement> getFields(TypeElement d) {
        return ElementFilter.fieldsIn(new LinkedHashSet<Element>(d.getEnclosedElements()));
    }

    public static Collection<ExecutableElement> getMethods(TypeElement d) {
        return ElementFilter.methodsIn(new LinkedHashSet<Element>(d.getEnclosedElements()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationMirrorComparator
    implements Comparator<AnnotationMirror> {
        private AnnotationMirrorComparator() {
        }

        @Override
        public int compare(AnnotationMirror a1, AnnotationMirror a2) {
            String n1 = a1.getAnnotationType().toString();
            String n2 = a2.getAnnotationType().toString();
            return n1.compareTo(n2);
        }

        public boolean equals(AnnotationMirror a1, AnnotationMirror a2) {
            return this.compare(a1, a2) == 0;
        }
    }
}

