/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.openal;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.openal.ALboolean;
import org.lwjgl.util.generator.openal.ALbyte;
import org.lwjgl.util.generator.openal.ALdouble;
import org.lwjgl.util.generator.openal.ALenum;
import org.lwjgl.util.generator.openal.ALfloat;
import org.lwjgl.util.generator.openal.ALint;
import org.lwjgl.util.generator.openal.ALshort;
import org.lwjgl.util.generator.openal.ALsizei;
import org.lwjgl.util.generator.openal.ALubyte;
import org.lwjgl.util.generator.openal.ALuint;
import org.lwjgl.util.generator.openal.ALvoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALTypeMap
implements TypeMap {
    private static final Map<Class, TypeKind> native_types_to_primitive = new HashMap<Class, TypeKind>();

    public TypeKind getPrimitiveTypeFromNativeType(Class native_type) {
        TypeKind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    public Signedness getSignednessFromType(Class type) {
        if (ALuint.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (ALint.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (ALshort.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (ALbyte.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(ALuint.class)) {
            return "i";
        }
        if (annotation_type.equals(ALint.class)) {
            return "i";
        }
        if (annotation_type.equals(ALshort.class)) {
            return "s";
        }
        if (annotation_type.equals(ALbyte.class)) {
            return "b";
        }
        if (annotation_type.equals(ALfloat.class)) {
            return "f";
        }
        if (annotation_type.equals(ALdouble.class)) {
            return "d";
        }
        if (annotation_type.equals(ALboolean.class) || annotation_type.equals(ALvoid.class)) {
            return "";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    @Override
    public Class getNativeTypeFromPrimitiveType(TypeKind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = ALint.class;
                break;
            }
            case FLOAT: {
                type = ALfloat.class;
                break;
            }
            case DOUBLE: {
                type = ALdouble.class;
                break;
            }
            case SHORT: {
                type = ALshort.class;
                break;
            }
            case BYTE: {
                type = ALbyte.class;
                break;
            }
            case BOOLEAN: {
                type = ALboolean.class;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{ALenum.class, ALint.class, ALsizei.class, ALuint.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{ALfloat.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{ALboolean.class, ALbyte.class, ALvoid.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{ALshort.class};
        }
        if (type.equals(DoubleBuffer.class)) {
            return new Class[]{ALdouble.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Integer.TYPE)) {
            return new Class[]{ALenum.class, ALint.class, ALsizei.class, ALuint.class};
        }
        if (type.equals(Double.TYPE)) {
            return new Class[]{ALdouble.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{ALfloat.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{ALshort.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{ALbyte.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{ALboolean.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{ALvoid.class};
        }
        return new Class[0];
    }

    @Override
    public void printCapabilitiesInit(PrintWriter writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCapabilities() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAPIUtilParam(boolean comma) {
        return "";
    }

    @Override
    public void printErrorCheckMethod(PrintWriter writer, ExecutableElement method, String tabs) {
        writer.println(tabs + "Util.checkALError();");
    }

    @Override
    public String getRegisterNativesFunctionName() {
        return "extal_InitializeClass";
    }

    @Override
    public String getTypedefPostfix() {
        return "";
    }

    @Override
    public String getFunctionPrefix() {
        return "ALAPIENTRY";
    }

    @Override
    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extal.h\"");
    }

    @Override
    public Class<? extends Annotation> getStringElementType() {
        return ALubyte.class;
    }

    @Override
    public Class<? extends Annotation> getStringArrayType() {
        return ALubyte.class;
    }

    @Override
    public Class<? extends Annotation> getByteBufferArrayType() {
        return ALubyte.class;
    }

    @Override
    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) ? ALTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? ALTypeMap.getValidPrimitiveTypes(type) : (type.equals(String.class) ? new Class[]{ALubyte.class} : new Class[]{}));
        return valid_types;
    }

    @Override
    public Class<? extends Annotation> getVoidType() {
        return ALvoid.class;
    }

    public Class<? extends Annotation> getInverseType(Class type) {
        if (ALuint.class.equals((Object)type)) {
            return ALint.class;
        }
        if (ALint.class.equals((Object)type)) {
            return ALuint.class;
        }
        return null;
    }

    @Override
    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        return null;
    }

    static {
        native_types_to_primitive.put(ALboolean.class, TypeKind.BOOLEAN);
        native_types_to_primitive.put(ALbyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(ALenum.class, TypeKind.INT);
        native_types_to_primitive.put(ALfloat.class, TypeKind.FLOAT);
        native_types_to_primitive.put(ALdouble.class, TypeKind.DOUBLE);
        native_types_to_primitive.put(ALint.class, TypeKind.INT);
        native_types_to_primitive.put(ALshort.class, TypeKind.SHORT);
        native_types_to_primitive.put(ALsizei.class, TypeKind.INT);
        native_types_to_primitive.put(ALubyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(ALuint.class, TypeKind.INT);
        native_types_to_primitive.put(ALvoid.class, TypeKind.BYTE);
    }
}

