/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.opengl.EGLint64NV;
import org.lwjgl.util.generator.opengl.EGLuint64NV;
import org.lwjgl.util.generator.opengl.GLbitfield;
import org.lwjgl.util.generator.opengl.GLboolean;
import org.lwjgl.util.generator.opengl.GLbyte;
import org.lwjgl.util.generator.opengl.GLchar;
import org.lwjgl.util.generator.opengl.GLclampf;
import org.lwjgl.util.generator.opengl.GLenum;
import org.lwjgl.util.generator.opengl.GLfloat;
import org.lwjgl.util.generator.opengl.GLhalf;
import org.lwjgl.util.generator.opengl.GLint;
import org.lwjgl.util.generator.opengl.GLint64;
import org.lwjgl.util.generator.opengl.GLintptr;
import org.lwjgl.util.generator.opengl.GLreturn;
import org.lwjgl.util.generator.opengl.GLshort;
import org.lwjgl.util.generator.opengl.GLsizei;
import org.lwjgl.util.generator.opengl.GLsizeiptr;
import org.lwjgl.util.generator.opengl.GLubyte;
import org.lwjgl.util.generator.opengl.GLuint;
import org.lwjgl.util.generator.opengl.GLuint64;
import org.lwjgl.util.generator.opengl.GLushort;
import org.lwjgl.util.generator.opengl.GLvoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLESTypeMap
implements TypeMap {
    private static final Map<Class<? extends Annotation>, TypeKind> native_types_to_primitive = new HashMap<Class<? extends Annotation>, TypeKind>();

    @Override
    public TypeKind getPrimitiveTypeFromNativeType(Class<? extends Annotation> native_type) {
        TypeKind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    @Override
    public void printCapabilitiesInit(PrintWriter writer) {
        writer.println("\t\tContextCapabilities caps = GLContext.getCapabilities();");
    }

    @Override
    public String getCapabilities() {
        return "caps";
    }

    @Override
    public String getAPIUtilParam(boolean comma) {
        return "";
    }

    @Override
    public void printErrorCheckMethod(PrintWriter writer, ExecutableElement method, String tabs) {
        writer.println(tabs + "Util.checkGLError();");
    }

    @Override
    public String getRegisterNativesFunctionName() {
        return "extgl_InitializeClass";
    }

    @Override
    public Signedness getSignednessFromType(Class<? extends Annotation> type) {
        if (GLuint.class.equals(type)) {
            return Signedness.UNSIGNED;
        }
        if (GLint.class.equals(type)) {
            return Signedness.SIGNED;
        }
        if (GLushort.class.equals(type)) {
            return Signedness.UNSIGNED;
        }
        if (GLshort.class.equals(type)) {
            return Signedness.SIGNED;
        }
        if (GLubyte.class.equals(type)) {
            return Signedness.UNSIGNED;
        }
        if (GLbyte.class.equals(type)) {
            return Signedness.SIGNED;
        }
        if (EGLuint64NV.class.equals(type)) {
            return Signedness.UNSIGNED;
        }
        if (EGLint64NV.class.equals(type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(GLuint64.class) || annotation_type.equals(GLint64.class)) {
            return "i64";
        }
        if (annotation_type.equals(GLuint.class) || annotation_type.equals(GLint.class)) {
            return "i";
        }
        if (annotation_type.equals(GLushort.class) || annotation_type.equals(GLshort.class)) {
            return "s";
        }
        if (annotation_type.equals(GLubyte.class) || annotation_type.equals(GLbyte.class)) {
            return "b";
        }
        if (annotation_type.equals(GLfloat.class)) {
            return "f";
        }
        if (annotation_type.equals(GLhalf.class)) {
            return "h";
        }
        if (annotation_type.equals(GLboolean.class) || annotation_type.equals(GLvoid.class)) {
            return "";
        }
        if (annotation_type.equals(EGLuint64NV.class) || annotation_type.equals(EGLint64NV.class)) {
            return "l";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    @Override
    public Class<? extends Annotation> getNativeTypeFromPrimitiveType(TypeKind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = GLint.class;
                break;
            }
            case FLOAT: {
                type = GLfloat.class;
                break;
            }
            case SHORT: {
                type = GLshort.class;
                break;
            }
            case BYTE: {
                type = GLbyte.class;
                break;
            }
            case BOOLEAN: {
                type = GLboolean.class;
                break;
            }
            case LONG: {
                type = GLint64.class;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    @Override
    public Class<? extends Annotation> getVoidType() {
        return GLvoid.class;
    }

    @Override
    public Class<? extends Annotation> getStringElementType() {
        return GLubyte.class;
    }

    @Override
    public Class<? extends Annotation> getStringArrayType() {
        return GLchar.class;
    }

    @Override
    public Class<? extends Annotation> getByteBufferArrayType() {
        return GLubyte.class;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLint.class, GLsizei.class, GLuint.class, GLvoid.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{GLboolean.class, GLbyte.class, GLchar.class, GLubyte.class, GLvoid.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(LongBuffer.class)) {
            return new Class[]{GLint64.class, GLuint64.class, EGLint64NV.class, EGLuint64NV.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Long.TYPE)) {
            return new Class[]{GLintptr.class, GLsizeiptr.class, GLint64.class, GLuint64.class, EGLuint64NV.class, EGLint64NV.class};
        }
        if (type.equals(Integer.TYPE)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLint.class, GLuint.class, GLsizei.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{GLbyte.class, GLchar.class, GLubyte.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{GLboolean.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{GLvoid.class, GLreturn.class};
        }
        return new Class[0];
    }

    @Override
    public String getTypedefPostfix() {
        return "GL_APICALL ";
    }

    @Override
    public String getFunctionPrefix() {
        return "GL_APIENTRY";
    }

    @Override
    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extgl.h\"");
    }

    @Override
    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) ? GLESTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? GLESTypeMap.getValidPrimitiveTypes(type) : (String.class.equals((Object)type) ? new Class[]{GLubyte.class} : (org.lwjgl.PointerWrapper.class.isAssignableFrom(type) ? new Class[]{PointerWrapper.class} : (Void.TYPE.equals(type) ? new Class[]{GLreturn.class} : new Class[]{}))));
        return valid_types;
    }

    @Override
    public Class<? extends Annotation> getInverseType(Class<? extends Annotation> type) {
        if (GLuint64.class.equals(type)) {
            return GLint64.class;
        }
        if (GLuint.class.equals(type)) {
            return GLint.class;
        }
        if (GLint.class.equals(type)) {
            return GLuint.class;
        }
        if (GLushort.class.equals(type)) {
            return GLshort.class;
        }
        if (GLshort.class.equals(type)) {
            return GLushort.class;
        }
        if (GLubyte.class.equals(type)) {
            return GLbyte.class;
        }
        if (GLbyte.class.equals(type)) {
            return GLubyte.class;
        }
        return null;
    }

    @Override
    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        Class<? extends Annotation> annotation_class = NativeTypeTranslator.getClassFromType(annotation.getAnnotationType());
        if (annotation_class.equals(GLint.class)) {
            return "GLES20.GL_INT";
        }
        if (annotation_class.equals(GLbyte.class)) {
            return "GLES20.GL_BYTE";
        }
        if (annotation_class.equals(GLshort.class)) {
            return "GLES20.GL_SHORT";
        }
        if (annotation_class.equals(GLuint.class)) {
            return "GLES20.GL_UNSIGNED_INT";
        }
        if (annotation_class.equals(GLubyte.class)) {
            return "GLES20.GL_UNSIGNED_BYTE";
        }
        if (annotation_class.equals(GLushort.class)) {
            return "GLES20.GL_UNSIGNED_SHORT";
        }
        if (annotation_class.equals(GLfloat.class)) {
            return "GLES20.GL_FLOAT";
        }
        return null;
    }

    static {
        native_types_to_primitive.put(GLbitfield.class, TypeKind.INT);
        native_types_to_primitive.put(GLclampf.class, TypeKind.FLOAT);
        native_types_to_primitive.put(GLfloat.class, TypeKind.FLOAT);
        native_types_to_primitive.put(GLint.class, TypeKind.INT);
        native_types_to_primitive.put(GLshort.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLsizeiptr.class, TypeKind.LONG);
        native_types_to_primitive.put(GLuint.class, TypeKind.INT);
        native_types_to_primitive.put(GLboolean.class, TypeKind.BOOLEAN);
        native_types_to_primitive.put(GLchar.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLhalf.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLsizei.class, TypeKind.INT);
        native_types_to_primitive.put(GLushort.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLbyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLenum.class, TypeKind.INT);
        native_types_to_primitive.put(GLintptr.class, TypeKind.LONG);
        native_types_to_primitive.put(GLubyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLvoid.class, TypeKind.BYTE);
        native_types_to_primitive.put(EGLint64NV.class, TypeKind.LONG);
        native_types_to_primitive.put(EGLuint64NV.class, TypeKind.LONG);
        native_types_to_primitive.put(GLint64.class, TypeKind.LONG);
        native_types_to_primitive.put(GLuint64.class, TypeKind.LONG);
    }
}

